package csbase.client.csdk.v1_0.extras.user;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.csdk.v1_0.core.CSDKAbstractContext;
import csbase.client.desktop.RemoteTask;
import csbase.logic.User;
import csbase.logic.UserOutline;
import csdk.v1_0.api.user.IUser;
import csdk.v1_0.api.user.IUserContext;
import csdk.v1_0.api.user.UserException;

/**
 * Implementao do contexto de usurios do CSDK, que permite a consulta aos
 * dados de todos os usurios do sistema, incluindo o usurio logado.
 */
public class CSDKUserContext extends CSDKAbstractContext implements
  IUserContext {

  /**
   * {@inheritDoc}
   */
  @Override
  public IUser getCurrentUser() throws UserException {
    User user = User.getLoggedUser();
    if (user == null) {
      return null;
    }
    return new CSDKUser(user);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public IUser[] getAllUsers(Window window) throws UserException {
    RemoteTask<List<UserOutline>> task = new RemoteTask<List<UserOutline>>() {
      @Override
      protected void performTask() throws Exception {
        setResult(User.getAllOutlines());
      }
    };
    String msg =
      LNG.get(CSDKUserContext.class.getSimpleName() + ".all.users.task");
    if (!task.execute(window, null, msg)) {
      String errorMsg =
        LNG.get(CSDKUserContext.class.getSimpleName() + ".all.users.error");
      throw new UserException(errorMsg);
    }
    List<UserOutline> outlines = task.getResult();
    List<IUser> users = new ArrayList<IUser>();
    for (UserOutline outline : outlines) {
      users.add(new CSDKUser(outline));
    }
    return users.toArray(new IUser[users.size()]);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public IUser getUserByLogin(final String login, Window window)
    throws UserException {
    if (login == null) {
      String errorMsg =
        LNG.get(CSDKUserContext.class.getSimpleName() + ".null.login.error");
      throw new UserException(errorMsg);
    }
    RemoteTask<User> task = new RemoteTask<User>() {
      @Override
      protected void performTask() throws Exception {
        setResult(User.getUserByLogin(login));
      }
    };
    String msg =
      LNG.get(CSDKUserContext.class.getSimpleName() + ".user.by.login.task");
    if (!task.execute(window, null, msg)) {
      String errorMsg =
        LNG.get(CSDKUserContext.class.getSimpleName() + ".user.by.login.error",
          new Object[] { login });
      throw new UserException(errorMsg);
    }
    User user = task.getResult();
    if (user == null) {
      return null;
    }
    return new CSDKUser(user);
  }

}
