package csbase.client.ias;

import csbase.logic.UserInfo;

/**
 * Interface para servir de Visitor para o UserInfoDialog
 * de incluso de usurio e as classes clientes. 
 * Toda aplicao/classe que quiser visitar o UserInfoDialog
 * para obter o login digitado pelo usurio, dever implementar esta
 * interface.
 * 
 * Assim, ser possvel obter informaes adicionais a partir do login
 * e devolver essas informaes ao Dialog para preencher automaticamente os demais
 * campos da tela de incluso de usurio.
 * 
 * Esta interface tem um mtodo abstrato para permitir o envio do login
 * digitado para a classe que o chamou. Este mtodo, quando implementado,
 * poder chamar qualquer servio para obter as informaes adicionais de usurios.
 *  
 * @author TecGraf PUC-Rio
 *
 */
public interface UserInfoCallBackInterface {
  

  /**
   * Obtm informaes adicionais do usurio
   * que sero devolvidas para a classe que chamou este mtodo.
   * @param attribute - Informao do usurio usada para obter outras informaes.
   * @return
   */
  public UserInfo obtainUserInfo(String login);
    
}
