package csbase.client.preferences.types;

import java.awt.Dimension;

import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.editors.PVDimensionEditor;
import csbase.client.preferences.util.PreferenceBundle;

/**
 * Preferncia que encapsula um objeto do tipo {@link Dimension}. Este valor
 * deve ser usado da seguinte forma:<br/>
 * 
 * \@Value(type=PVDimension.class, defaultValue="800,600")
 * 
 * @see PreferenceValue PreferenceCategory PreferencePolicy
 * 
 * @author Tecgraf
 */
public class PVDimension extends PreferenceValue<Dimension> {

  /**
   * Construtor usado na instanciao desta classe por reflexo.
   * 
   * @param name nome da preferncia que possui este valor.
   * @param value valor da preferncia.
   * @param defaultValue valor default da preferncia.
   * @param policy poltica de visibilidade do valor.
   * @param preferenceBundle objeto responsvel pela internacionalizao.
   */
  public PVDimension(PreferenceDefinition name, String value,
    String defaultValue, PreferencePolicy policy,
    PreferenceBundle preferenceBundle) {
    super(name, value, defaultValue, policy, preferenceBundle);

    setPreferenceEditorClass(PVDimensionEditor.class);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getClassName() {
    return getClass().getName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return getValue().width + "," + getValue().height;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Dimension toValue(String value) {
    String[] split = value.split(" *, *");
    int width = Integer.parseInt(split[0]);
    int height = Integer.parseInt(split[1]);
    return new Dimension(width, height);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public PreferenceValue<Dimension> clone() {
    return new PVDimension(name, this.toString(), defaultValue, policy,
      preferenceBundle);
  }
}
