package csbase.client.preferences.types;

import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.editors.PVIntegerEditor;
import csbase.client.preferences.util.PreferenceBundle;

/**
 * Preferncia que encapsula um valor inteiro. Este valor deve ser usado da
 * seguinte forma:<br/>
 * 
 * \@Value(type=PVInteger.class, defaultValue="200")
 * 
 * @see PreferenceValue PreferenceCategory PreferencePolicy
 * 
 * @author Tecgraf
 */
public class PVInteger extends PreferenceValue<Integer> {

  /**
   * Construtor usado na instanciao desta classe por reflexo.
   * 
   * @param name nome da preferncia que possui este valor.
   * @param value valor da preferncia.
   * @param defaultValue valor default da preferncia.
   * @param policy poltica de visibilidade do valor.
   * @param preferenceBundle objeto responsvel pela internacionalizao.
   */
  public PVInteger(PreferenceDefinition name, String value,
    String defaultValue, PreferencePolicy policy,
    PreferenceBundle preferenceBundle) {
    super(name, value, defaultValue, policy, preferenceBundle);

    setPreferenceEditorClass(PVIntegerEditor.class);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getClassName() {
    return getClass().getName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Integer toValue(String value) {
    return Integer.parseInt(value);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return getValue().toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public PreferenceValue<Integer> clone() {
    return new PVInteger(name, this.toString(), defaultValue, policy,
      preferenceBundle);
  }
}
