/*
 * $Id: CommonFileTypeChangeAction.java 116325 2011-03-18 03:17:58Z cassino $
 */
package csbase.client.project.action;

import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.Client;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.ProjectTree;
import csbase.client.project.tasks.ChangeFileTypeTask;
import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileType;
import csbase.logic.filetypefinder.FileTypeFinder;

/**
 * Ao que abre dilogo para "alterao de tipo" de arquivo da rvore de
 * projetos.
 *
 * @author Tecgraf/PUC-Rio
 */
public class CommonFileTypeInferAction extends CommonProjectAction {

  /**
   * Construtor.
   *
   * @param container container
   */
  public CommonFileTypeInferAction(ProjectFileContainer container) {
    super(container);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    DesktopFrame desktop = DesktopFrame.getInstance();
    ProjectTree projTree = desktop.getTree();
    FileTypeFinder fileTypeFinder = projTree.getFileTypeFinder();
    if (fileTypeFinder == null) {
      return;
    }
    ClientProjectFile file = getSelectedFile();
    ProjectFileType type =
      fileTypeFinder.inferType(file, Client.getInstance()
        .getSystemDefaultCharset());
    if (type == null) {
      return;
    }
    DesktopComponentFrame dskFrame = desktop.getDesktopFrame();
    ChangeFileTypeTask.runTask(dskFrame, file, type);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return LNG.get("PRJ_INFER_TYPE");
  }
}
