/*
 * $Id$
 */
package csbase.client.project.action;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.ClientKeyStrokeUtil;

/**
 * Ao para exibir ou esconder o painel de filtro da rvore de projetos.
 * 
 * @author Tecgraf
 */
public class ShowTreeFilterAction extends AbstractAction {

  /** Painel de filtro. */
  private JPanel filterPanel;

  /**
   * Cria a ao.
   * 
   * @param filterPanel painel de filtro da rvore de projetos.
   */
  public ShowTreeFilterAction(JPanel filterPanel) {
    putValue(Action.NAME, LNG.get("ShowTreeFilterAction.name"));
    final String accKey = "ShowTreeFilterAction.accelerator";
    if (LNG.hasKey(accKey)) {
      final String accText = LNG.get(accKey);
      final KeyStroke stroke = ClientKeyStrokeUtil.getCtrlKeyStroke(accText);
      putValue(Action.ACCELERATOR_KEY, stroke);
    }
    this.filterPanel = filterPanel;
  }

  /**
   * Se o painel estiver escondido, exibe; se estiver visvel, esconde.
   * 
   * @param e informaes sobre o evento (no consideradas).
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    filterPanel.setVisible(!filterPanel.isVisible());
  }
}
