package csbase.client.remote;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;

/**
 * A interface <code>AlgorithmManagementListener</code> modela um listener para
 * algoritmos e categorias carregadas no cliente.
 * 
 * Esse listener permite que eventos ocorridos no servio de algoritmos, como a
 * criao, alterao ou remoo de algoritmos ou de categorias, sejam
 * notificados a todos os aplicativos ou janelas registrados no
 * AlgorithmManagementProxy.
 * 
 * 
 * @author pizzol
 */
public interface AlgorithmManagementListener {

  /**
   * Notifica que uma nova categoria foi criada no conjunto de categorias
   * disponvel na aplicao.
   * 
   * @param category categoria criada
   * 
   */
  public void categoryCreated(Category category);

  /**
   * Notifica que uma categoria foi removida do conjunto de categorias
   * disponvel na aplicao.
   * 
   * @param category categoria removida
   * 
   */
  public void categoryRemoved(Category category);

  /**
   * Notifica que um conjunto de categorias foi modificado no conjunto de
   * categorias disponvel na aplicao.
   * 
   * @param modifiedCategorySet conjunto com as categorias modificadas
   * 
   */
  public void categoryUpdated(CategorySet modifiedCategorySet);

  /**
   * Notifica que um novo algoritmo foi criado no conjunto de algoritmos
   * disponvel na aplicao.
   * 
   * @param algoInfo algoritmo criado
   * 
   */
  public void algorithmCreated(AlgorithmInfo algoInfo);

  /**
   * Notifica que um algoritmo foi removido do conjunto de algoritmos disponvel
   * na aplicao.
   * 
   * @param algoInfo algoritmo removido
   * 
   */
  public void algorithmRemoved(AlgorithmInfo algoInfo);

  /**
   * Notifica que um algoritmo foi alterado no conjunto de algoritmos disponvel
   * na aplicao.
   * 
   * @param algoInfo algoritmo alterado
   * 
   */
  public void algorithmUpdated(AlgorithmInfo algoInfo);

  /**
   * Notifica que o conjunto de algoritmos foram recarregados no servidor.
   */
  public void algorithmsReloaded();
}
