package csbase.client.util;

import java.awt.Color;

/**
 * A classe <code>MonitoringTheme</code> define o padro de cores para
 * interfaces de monitorao.
 */
public class MonitoringTheme {
  private static final Color RANGE_NORMAL_COLOR = new Color(200, 255, 200);
  private static final Color RANGE_WARNING_COLOR = new Color(255, 255, 200);
  private static final Color RANGE_ALERT_COLOR = new Color(255, 200, 210);
  private static final Color RANGE_PANIC_COLOR = new Color(180, 90, 255);
  private static final Color RANGE_ERROR_COLOR = new Color(180, 90, 255);
  private static final Color RANGE_DEFAULT_COLOR = new Color(210, 210, 255);
  private static final Color OUT_COLOR = Color.gray;
  private static final Color PROCESSOR_COLOR = new Color(159, 113, 255);
  private static final Color RAM_MEMORY_COLOR = new Color(190, 99, 145);
  private static final Color SWAP_MEMORY_COLOR = new Color(245, 150, 65);
  private static final Color USED_COLOR = new Color(82, 121, 165);
  private static final Color FREE_COLOR = new Color(229, 229, 229);
  private static final Color[][] DATA_PALETTE =
  {
    {
      new Color(255, 242, 204), new Color(242, 218, 169),
      new Color(229, 172, 91), new Color(204, 117, 30), new Color(178, 81, 12),
      new Color(122, 50, 14),
    },
    {
      new Color(229, 241, 255), new Color(193, 216, 242),
      new Color(164, 190, 219), new Color(132, 158, 188),
      new Color(82, 121, 165), new Color(76, 100, 127),
    },
    {
      new Color(229, 229, 229), new Color(204, 204, 204),
      new Color(178, 178, 178), new Color(153, 153, 153),
      new Color(127, 127, 127), new Color(102, 102, 102),
    },
  };
  private static final Color GRID_COLOR = Color.lightGray;
  private static final Color AXIS_COLOR = Color.gray;
  
  public static Color getRangeNormalColor() {
    return RANGE_NORMAL_COLOR;
  }

  public static Color getRangeWarningColor() {
    return RANGE_WARNING_COLOR;
  }

  public static Color getRangeAlertColor() {
    return RANGE_ALERT_COLOR;
  }

  public static Color getRangePanicColor() {
    return RANGE_PANIC_COLOR;
  }

  public static Color getRangeErrorColor() {
    return RANGE_ERROR_COLOR;
  }

  public static Color getRangeDefaultColor() {
    return RANGE_DEFAULT_COLOR;
  }

  public static Color getOutColor() {
    return OUT_COLOR;
  }

  public static Color getProcessorColor() {
    return PROCESSOR_COLOR;
  }

  public static Color getRAMMemoryColor() {
    return RAM_MEMORY_COLOR;
  }

  public static Color getSwapMemoryColor() {
    return SWAP_MEMORY_COLOR;
  }

  public static Color getAxisColor() {
    return AXIS_COLOR;
  }

  public static Color getGridColor() {
    return GRID_COLOR;
  }

  public static int getDataPaletteRowCount() {
    return DATA_PALETTE.length;
  }

  public static int getDataPaletteColumnCount() {
    return DATA_PALETTE[0].length;
  }

  public static Color getDataPaletteColor(int row, int col) {
    return DATA_PALETTE[row][col];
  }

  public static Color getUsedColor() {
    return USED_COLOR;
  }

  public static Color getFreeColor() {
    return FREE_COLOR;
  }
}
