/*
 * NumericTextField.java
 *
 * $Author: mjulia $
 * $Revision: 144754 $  - $Date: 2013-09-19 18:38:30 -0300 (Thu, 19 Sep 2013) $
 */
package csbase.client.util;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

/**
 * Representa um campo de entrada de texto que somente aceita caracteres
 * numricos (no decimal).
 */
public class NumericTextField extends JTextField {
  /**
   * Cria um modelo que aceita apenas caracteres nmericos.
   *
   * @return .
   */
  protected Document createDefaultModel() {
    return new NumericDocument();
  }

  /**
   * Modelo para entrada de valor numrico.
   */
  static class NumericDocument extends PlainDocument {
    public void insertString(int offs, String str, AttributeSet a)
      throws BadLocationException {
      if (str == null) {
        return;
      }
      if (str.matches("[0-9]+")) {
        super.insertString(offs, str, a);
      }
    }
  }

  /**
   * Construtor.
   *
   * @param cols .
   */
  public NumericTextField(int cols) {
    super(cols);
  }
}
