/*
 * Detalhes da ltima alterao:
 *
 * $Author: rodrigoh $
 * $Date: 2006-04-24 22:36:58 -0300 (Mon, 24 Apr 2006) $
 * $Revision: 36854 $
 */
package csbase.client.util;

import java.util.Observable;

/**
 * <p>Esta classe representa um observador que tratar, na thread do Swing
 * (EDT - Event Dispatcher Thread), a notificao dos eventos recebidos por um
 * observvel.</p>
 * 
 * @see java.util.Observable
 *
 * @author Tecgraf/PUC-Rio
 */
public interface SwingObserver {
  /**
   * O mtodo doUpdate  chamado quando ocorre uma mudana no objeto
   * observador e  executado na thread do Swing (EDT).
   *
   * @param observable O observvel que gerou a notificao.
   * @param arg O argumento enviado pelo observvel na notificao.
   */
  void doUpdate(Observable observable, Object arg);
}
