package csbase.client.util.filechooser.images;

import java.net.URL;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;

/**
 * Imagens usadas no chooser global.
 *
 * @author Tecgraf/PUC-Rio
 */
public class ChooserImages {

  /** Representa o home para arquivos locais. */
  final public static ImageIcon LOCAL_HOME_ICON =
    loadImageIcon("local-home-icon.gif");

  /** Representa o diretrio raz para arquivos locais. */
  final public static ImageIcon LOCAL_ROOT_ICON =
    loadImageIcon("local-root-icon.gif");

  /** Representa o home para arquivos de projeto. */
  final public static ImageIcon PROJECT_HOME_ICON =
    ApplicationImages.ICON_FOLDER_16;

  /** Representa diretrio de arquivo de projeto. */
  final public static ImageIcon PROJECT_DIRECTORY_ICON =
    ApplicationImages.ICON_FOLDER_16;

  /** Representa ir para o diretrio pai. */
  final public static ImageIcon PARENT_FOLDER_IMG =
    loadImageIcon("folder-parent-img.gif");

  /** Representa diretrio sem permisso. */
  final public static ImageIcon FOLDER_NO_PERMISSION_IMG =
    loadImageIcon("folder-no-permission-img.gif");

  /** Representa o filtro que visualiza arquivos ocultos. */
  final public static ImageIcon FILTER_HIDDEN_IMG =
    loadImageIcon("filter-hidden-img.gif");

  /** Representa diretrio local e SGA. */
  final public static ImageIcon DIRECTORY_ICON =
    ApplicationImages.ICON_SIMPLE_FOLDER_16;

  /** Representa um novo diretrio. */
  final public static ImageIcon NEW_DIRECTORY_ICON =
    ApplicationImages.ICON_NEW_FOLDER_16;

  /** Representa diretrio oculto. */
  final public static ImageIcon DIRECTORY_GRAY_ICON =
    ApplicationImages.ICON_SIMPLE_FOLDER_HIDDEN_16;

  /** Representa diretrio fechado. */
  final public static ImageIcon LOCKED_DIRECTORY_ICON =
    ApplicationImages.ICON_SIMPLE_FOLDER_LOCKED_16;

  /** Representa arquivo fechado. */
  final public static ImageIcon LOCKED_FILE_ICON =
    loadImageIcon("local-locked-file-icon.gif");

  /**
   * Carga de imagem.
   *
   * @param path path
   * @return a imagem
   */
  private static ImageIcon loadImageIcon(String path) {
    final URL url = ChooserImages.class.getResource(path);
    if (url == null) {
      return null;
    }
    return new ImageIcon(url);
  }
}
