/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.ClientLocalFile;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.URLListParameterView;
import csbase.client.algorithms.parameters.URLParameterView;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil;
import csbase.client.util.filechooser.ClientSGAFileChooserUtil;
import csbase.client.util.filechooser.util.ClientFileChooserUtils;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import csbase.logic.ClientSGAFile;
import csbase.logic.SGASet;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.OutputURLListParameter;
import csbase.logic.algorithms.parameters.URLListParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public class OutputURLListParameterView
extends URLListParameterView {
    public OutputURLListParameterView(OutputURLListParameter parameter, ParameterView.Mode mode) {
        super((URLListParameter)parameter, mode);
    }

    @Override
    public OutputURLListParameter getParameter() {
        return (OutputURLListParameter)super.getParameter();
    }

    @Override
    protected List<FileURLValue> askForFile(URLProtocol fileProtocol, Object ... args) {
        String fileType = this.getParameter().getFileType();
        ClientFileChooserSelectionMode selectionMode = this.getFileChooserMode();
        String title = this.getParameter().getLabel();
        switch (fileProtocol) {
            case PROJECT: {
                return this.askForProjectFile(fileType, true, selectionMode, title);
            }
            case LOCAL: {
                return this.askForLocalFile(fileType, true, selectionMode, title);
            }
            case SGA: {
                String sgaName = (String)args[0];
                return this.askForSGAFile(fileType, true, selectionMode, title, sgaName);
            }
        }
        return null;
    }

    private List<FileURLValue> askForProjectFile(String fileType, boolean allowAll, ClientFileChooserSelectionMode selectionMode, String title) {
        ArrayList<FileURLValue> urls = new ArrayList<FileURLValue>();
        switch (selectionMode) {
            case DIRECTORIES_ONLY: {
                List<ClientProjectFileChooserUtil.OperationResult> selectedDirs = ClientProjectFileChooserUtil.browseMultipleDirectoriesInOpenMode(this.getWindow(), fileType, title, allowAll);
                if (selectedDirs == null) {
                    return null;
                }
                for (ClientProjectFileChooserUtil.OperationResult selectedDir : selectedDirs) {
                    ClientProjectFile dir = selectedDir.getClientProjectFile();
                    urls.add(this.getURLFromFile(URLProtocol.PROJECT, (ClientFile)dir, null));
                }
                break;
            }
            case FILES_ONLY: {
                List<ClientProjectFileChooserUtil.OperationResult> selectedFiles = ClientProjectFileChooserUtil.browseMultipleFilesInOpenMode(this.getWindow(), Arrays.asList(fileType), title, allowAll);
                if (selectedFiles == null) {
                    return null;
                }
                for (ClientProjectFileChooserUtil.OperationResult selectedFile : selectedFiles) {
                    ClientProjectFile file = selectedFile.getClientProjectFile();
                    urls.add(this.getURLFromFile(URLProtocol.PROJECT, (ClientFile)file, null));
                }
                break;
            }
            default: {
                return null;
            }
        }
        return urls;
    }

    private List<FileURLValue> askForLocalFile(String fileType, boolean allowAll, ClientFileChooserSelectionMode selectionMode, String title) {
        ArrayList<FileURLValue> urls = new ArrayList<FileURLValue>();
        LinkedList<String> fileTypes = new LinkedList<String>();
        if (fileType != null) {
            fileTypes.add(fileType);
        }
        switch (selectionMode) {
            case DIRECTORIES_ONLY: {
                List<ClientLocalFile> selectedDirs = ClientLocalFileChooserUtil.browseMultipleDirectoriesInOpenMode(this.getWindow(), fileTypes, title, allowAll, ClientFileChooserUtils.getLocalHomeDirectory());
                if (selectedDirs == null) {
                    return null;
                }
                for (ClientLocalFile selectedDir : selectedDirs) {
                    urls.add(this.getURLFromFile(URLProtocol.LOCAL, selectedDir, null));
                }
                break;
            }
            case FILES_ONLY: {
                List<ClientLocalFile> selectedFiles = ClientLocalFileChooserUtil.browseMultipleFilesInOpenMode(this.getWindow(), fileTypes, title, allowAll, ClientFileChooserUtils.getLocalHomeDirectory());
                if (selectedFiles == null) {
                    return null;
                }
                for (ClientLocalFile selectedFile : selectedFiles) {
                    urls.add(this.getURLFromFile(URLProtocol.LOCAL, selectedFile, null));
                }
                break;
            }
            default: {
                return null;
            }
        }
        return urls;
    }

    private List<FileURLValue> askForSGAFile(String fileType, boolean allowAll, ClientFileChooserSelectionMode selectionMode, String title, final String sgaName) {
        if (sgaName == null) {
            return null;
        }
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        RemoteTask<Boolean> sgaIsAliveTask = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                SGASet sga = sgaService.getSGASet(sgaName);
                this.setResult(sga.getAlive());
            }
        };
        boolean isAlive = false;
        String description = LNG.get((String)(URLParameterView.class.getSimpleName() + ".sga_alive_task"));
        if (sgaIsAliveTask.execute(this.getWindow(), title, description)) {
            isAlive = (Boolean)sgaIsAliveTask.getResult();
        }
        if (!isAlive) {
            String errorMessage = LNG.get((String)(URLParameterView.class.getSimpleName() + ".sga_not_alive"), (Object[])new Object[]{sgaName});
            StandardErrorDialogs.showErrorDialog(this.getWindow(), errorMessage);
            return null;
        }
        ClientSGAFile root = new ClientSGAFile(sgaName, "/");
        ArrayList<FileURLValue> urls = new ArrayList<FileURLValue>();
        LinkedList<String> fileTypes = new LinkedList<String>();
        if (fileType != null) {
            fileTypes.add(fileType);
        }
        switch (selectionMode) {
            case DIRECTORIES_ONLY: {
                List<ClientSGAFile> selectedDirs = ClientSGAFileChooserUtil.browseMultipleDirectoriesInOpenMode(this.getWindow(), fileTypes, title, true, root);
                if (selectedDirs == null) {
                    return null;
                }
                for (ClientSGAFile selectedDir : selectedDirs) {
                    urls.add(this.getURLFromFile(URLProtocol.SGA, (ClientFile)selectedDir, sgaName));
                }
                break;
            }
            case FILES_ONLY: {
                List<ClientSGAFile> selectedFiles = ClientSGAFileChooserUtil.browseMultipleFilesInOpenMode(this.getWindow(), fileTypes, title, true, root);
                if (selectedFiles == null) {
                    return null;
                }
                for (ClientSGAFile selectedFile : selectedFiles) {
                    urls.add(this.getURLFromFile(URLProtocol.SGA, (ClientFile)selectedFile, sgaName));
                }
                break;
            }
            default: {
                return null;
            }
        }
        return urls;
    }

    private FileURLValue getURLFromFile(URLProtocol fileProtocol, ClientFile file, String host) {
        if (file == null) {
            return null;
        }
        String type = file.getType();
        return new FileURLValue(file.getStringPath(), type, fileProtocol, host);
    }

    private ClientFileChooserSelectionMode getFileChooserMode() {
        FileParameterMode parameterMode = this.getParameter().getMode();
        switch (parameterMode) {
            case REGULAR_FILE: {
                return ClientFileChooserSelectionMode.FILES_ONLY;
            }
            case DIRECTORY: {
                return ClientFileChooserSelectionMode.DIRECTORIES_ONLY;
            }
        }
        String errorMessage = MessageFormat.format("O modo {0} n\u00e3o \u00e9 v\u00e1lido.", parameterMode);
        throw new IllegalStateException(errorMessage);
    }
}

