/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.validation;

import csbase.logic.algorithms.validation.FlowNodeValidationResult;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import tecgraf.javautils.core.lng.LNG;

public class ValidationTranslator {
    public static String translateMessage(Validation validation) {
        StringBuilder message = new StringBuilder();
        if (validation != null) {
            message.append(ValidationTranslator.getMessage(validation.getMessage()));
            if (validation instanceof FlowNodeValidationResult) {
                FlowNodeValidationResult flowNodeValidation = (FlowNodeValidationResult)validation;
                String elementDescription = "(" + flowNodeValidation.getElement() + ") ";
                message.insert(0, elementDescription);
            }
        }
        return message.toString();
    }

    public static boolean hasLocalizedMessage(LocalizedMessage message) {
        if (message != null) {
            return LNG.hasKey((String)message.getKey());
        }
        return false;
    }

    public static String getMessage(LocalizedMessage message) {
        if (ValidationTranslator.hasLocalizedMessage(message)) {
            return ValidationTranslator.getLocalizedMessage(message);
        }
        return message.toString();
    }

    public static String getLocalizedMessage(LocalizedMessage message) {
        if (message != null) {
            Object[] args = message.getArgs();
            String key = message.getKey();
            if (args != null && args.length > 0) {
                return LNG.get((String)key, (Object[])args);
            }
            return LNG.get((String)key);
        }
        return "";
    }
}

