/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.actions;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.actions.CommonEditAction;
import csbase.client.applications.algorithmsmanager.dialogs.CommonSelectionPanel;
import csbase.client.applications.algorithmsmanager.models.CategoryNodeInterface;
import csbase.client.applications.algorithmsmanager.models.DataInterface;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.Category;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class CategoryRemoveAction
extends CommonEditAction {
    public CategoryRemoveAction(CommonSelectionPanel selectionPanel, ImageIcon icon) {
        super(selectionPanel, icon);
    }

    private int removeCategories(List<Category> categories) {
        int removedCounter = 0;
        for (Category category : categories) {
            boolean removed = AlgorithmManagementProxy.removeCategory(category.getId(), ((AlgorithmsManager)this.getApplication()).getApplicationFrame());
            if (!removed) continue;
            ++removedCounter;
        }
        return removedCounter;
    }

    @Override
    protected void handleEditOperation() {
        int removedCounter;
        List<DataInterface> categoriesNodeList = this.getSelectionPanel().getSelectedDataList();
        int option = ((AlgorithmsManager)this.getApplication()).showOptionDialog(this.getString("CategoryRemoveAction.msg.cancel.confirm", new Object[0]), new String[]{this.getString("CategoryRemoveAction.msg.cancel.confirm.yes", new Object[0]), this.getString("CategoryRemoveAction.msg.cancel.confirm.no", new Object[0])});
        if (option == 0 && (removedCounter = this.removeCategories(this.getCategories(categoriesNodeList))) != categoriesNodeList.size()) {
            String msg = MessageFormat.format(this.getString("CategoryRemoveAction.msg.error.remove.no_sucess", new Object[0]), removedCounter);
            ((AlgorithmsManager)this.getApplication()).showMessage(msg);
        }
    }

    private List<Category> getCategories(List<DataInterface> categoriesNodeList) {
        ArrayList<Category> categories = new ArrayList<Category>();
        for (DataInterface node : categoriesNodeList) {
            CategoryNodeInterface categoryNode = (CategoryNodeInterface)node;
            categories.add(categoryNode.getNode());
        }
        return categories;
    }
}

