/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.actions;

import csbase.client.applications.algorithmsmanager.actions.CommonVersionAction;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmVersionInfoPanel;
import csbase.client.applications.algorithmsmanager.dialogs.VersionDialog;
import csbase.client.applications.algorithmsmanager.versiontree.PropertiesPanel;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmProperty;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

public class VersionCreateAction
extends CommonVersionAction {
    public VersionCreateAction(AlgorithmVersionInfoPanel versionInfoPanel, ImageIcon icon) {
        super(versionInfoPanel, icon);
        this.setEnabled(true);
    }

    @Override
    protected void handleVersionOperation() {
        new AddVersionDialog().show();
    }

    private class AddVersionDialog
    extends VersionDialog {
        private List<AlgorithmProperty> versionProperties;
        private PropertiesPanel propertiesPanel;

        public AddVersionDialog() {
            super(VersionCreateAction.this.getSelectedAlgorithm());
            this.versionProperties = AlgorithmManagementProxy.getAlgorithmVersionProperties(VersionCreateAction.this.getWindow());
            this.propertiesPanel = new PropertiesPanel(this.versionProperties, new Hashtable<String, String>(), LNG.get((String)"algomanager.label.optional_properties"), VersionCreateAction.this.getWindow(), true);
        }

        public void show() {
            this.dialogTitle = String.format(LNG.get((String)"algomanager.title.include_version"), this.algoInfo.getName());
            this.dialog = new DesktopComponentDialog(VersionCreateAction.this.getWindow());
            this.dialog.setTitle(this.dialogTitle);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    AddVersionDialog.this.dialog.close();
                }
            });
            JPanel mainInfoPanel = new JPanel(new GridBagLayout());
            JLabel idLabel = new JLabel(LNG.get((String)"algomanager.label.version_id"));
            this.majorField = new JTextField(3);
            this.minorField = new JTextField(3);
            this.patchField = new JTextField(3);
            mainInfoPanel.add((Component)idLabel, new GBC(0, 0).none().west().insets(5, 5, 5, 5));
            mainInfoPanel.add((Component)this.majorField, new GBC(1, 0).none().west().insets(5, 5, 5, 5));
            mainInfoPanel.add((Component)this.minorField, new GBC(2, 0).none().west().insets(5, 5, 5, 5));
            mainInfoPanel.add((Component)this.patchField, new GBC(3, 0).none().west().insets(5, 5, 5, 5));
            JPanel infoPanel = new JPanel(new GridBagLayout());
            infoPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            infoPanel.add((Component)mainInfoPanel, new GBC(0, 0).none().west().insets(5, 5, 5, 5));
            if (this.versionProperties.size() > 0) {
                infoPanel.add((Component)this.propertiesPanel.getPropertiesPanel(), new GBC(0, 1).none().west().insets(5, 5, 5, 5));
            }
            JPanel buttonsPanel = new JPanel();
            JButton includeButton = new JButton(LNG.get((String)"algomanager.button.include"));
            includeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] vNumbers = AddVersionDialog.this.getVersionNumbers();
                    if (vNumbers != null && AddVersionDialog.this.propertiesPanel.validateProperties()) {
                        AddVersionDialog.this.createVersion(vNumbers[0], vNumbers[1], vNumbers[2]);
                        AddVersionDialog.this.dialog.close();
                    }
                }
            });
            JButton cancelButton = new JButton(LNG.get((String)"algomanager.button.cancel"));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddVersionDialog.this.dialog.close();
                }
            });
            ClientUtilities.adjustEqualSizes(includeButton, cancelButton);
            buttonsPanel.add(includeButton);
            buttonsPanel.add(cancelButton);
            this.dialog.add((Component)infoPanel, "Center");
            this.dialog.add((Component)buttonsPanel, "South");
            this.dialog.pack();
            this.dialog.center(VersionCreateAction.this.getWindow());
            this.dialog.setVisible(true);
        }

        private void createVersion(int major, int minor, int patch) {
            AlgorithmInfo algo = AlgorithmManagementProxy.createVersion(this.algoInfo.getId(), major, minor, patch, this.propertiesPanel.getProperties(), VersionCreateAction.this.getWindow());
            Object id = AlgorithmVersionInfo.getIdFor((int)major, (int)minor, (int)patch);
            if (algo == null) {
                StandardErrorDialogs.showErrorDialog((Window)this.dialog, LNG.get((String)"algomanager.title.error") + " - " + this.dialogTitle, MessageFormat.format(LNG.get((String)"algomanager.error.version_include"), id));
            }
        }
    }
}

