/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.dialogs.CategoryCreateDataPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CategorySelectionPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonEditTabbedPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonInfoEditPanel;
import csbase.logic.algorithms.Category;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import tecgraf.javautils.gui.GBC;

public class CategoryCreateInfoPanel
extends CommonInfoEditPanel {
    private JTextField tf_categoryParentName;
    private JTextField tf_categoryName;
    private boolean isEditing;

    public CategoryCreateInfoPanel(CommonEditTabbedPanel categoryPane) {
        super(categoryPane);
        this.setCancelActionState(true);
    }

    private JPanel getCategoryNamePanel() {
        JPanel namePanel = new JPanel(new GridBagLayout());
        JLabel categoryNameLabel = new JLabel(this.getString("CategoryCreateInfoPanel.label.name"));
        JLabel parentCategoryNameLabel = new JLabel(this.getString("CategoryCreateInfoPanel.label.parent.name"));
        this.tf_categoryParentName = new JTextField();
        this.tf_categoryParentName.setEditable(false);
        this.tf_categoryName = this.buildNameCategoryField();
        namePanel.add((Component)parentCategoryNameLabel, new GBC(0, 0).none().west().insets(5, 5, 5, 5));
        namePanel.add((Component)this.tf_categoryParentName, new GBC(1, 0).horizontal().west().insets(5, 5, 5, 5));
        namePanel.add((Component)categoryNameLabel, new GBC(0, 1).none().west().insets(5, 5, 5, 5));
        namePanel.add((Component)this.tf_categoryName, new GBC(1, 1).horizontal().west().insets(5, 5, 5, 5));
        return namePanel;
    }

    private JTextField buildNameCategoryField() {
        this.tf_categoryName = new JTextField(20);
        this.tf_categoryName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CategoryCreateInfoPanel.this.apply();
                }
            }
        });
        this.tf_categoryName.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                JTextField tf = (JTextField)e.getSource();
                boolean hasName = !tf.getText().trim().isEmpty();
                CategoryCreateInfoPanel.this.isEditing = hasName;
                CategoryCreateInfoPanel.this.setApplyActionState(hasName);
            }
        });
        return this.tf_categoryName;
    }

    protected boolean createCategory() {
        String categoryName = this.getCategoryName();
        Category parentCategory = this.getParentCategory();
        boolean categoryExists = false;
        categoryExists = parentCategory != null ? parentCategory.containsCategory(categoryName) : ((AlgorithmsManager)this.getApplication()).containsCategory(categoryName);
        if (categoryExists) {
            ((AlgorithmsManager)this.getApplication()).showError(this.getString("CategoryCreateInfoPanel.msg.error.create.category_exists"));
            return false;
        }
        Category categoryCreated = this.getCategoryCreateDataPanel().createCategory(categoryName);
        if (categoryCreated == null) {
            ((AlgorithmsManager)this.getApplication()).showError(this.getString("CategoryCreateInfoPanel.msg.error.create.no_sucess"));
            return false;
        }
        return true;
    }

    private Category getParentCategory() {
        return this.getCategoryCreateDataPanel().getParentCategory();
    }

    private String getCategoryName() {
        return this.tf_categoryName.getText().trim();
    }

    @Override
    public void initializeData() {
        this.tf_categoryParentName.setText(this.getCategoryCreateDataPanel().getParentCategoryName());
        this.tf_categoryName.requestFocus();
    }

    @Override
    protected void apply() {
        this.isEditing = false;
        if (!this.createCategory()) {
            this.tf_categoryName.requestFocus();
        }
    }

    @Override
    protected void cancel() {
        boolean confirmCancelling;
        boolean bl = confirmCancelling = !this.wasModified() || this.wasModified() && this.confirmCancelling();
        if (confirmCancelling) {
            this.getCategoryCreateDataPanel().cancel();
            this.getSelectionPanel().selectCurrentCategory();
        }
    }

    private CategorySelectionPanel getSelectionPanel() {
        return this.getCategoryCreateDataPanel().getSelectionPanel();
    }

    private boolean confirmCancelling() {
        int confirm = ((AlgorithmsManager)this.getApplication()).showOptionDialog(this.getString("CategoryCreateInfoPanel.msg.cancel.confirm"), new String[]{this.getString("CategoryCreateInfoPanel.msg.cancel.confirm.yes"), this.getString("CategoryCreateInfoPanel.msg.cancel.confirm.no")});
        if (confirm == 0) {
            this.isEditing = false;
            return true;
        }
        return false;
    }

    @Override
    protected JPanel buildMainInfoPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel namePanel = this.getCategoryNamePanel();
        panel.add((Component)namePanel, new GBC(0, 0).horizontal().west().insets(0, 0, 0, 0));
        panel.add((Component)this.buildEmptyPanel(), new GBC(0, 1).both().west().insets(0, 0, 0, 0));
        return panel;
    }

    @Override
    public void setDataChanged() {
        this.isEditing = false;
        this.changeOperationsState(this.isEditing);
    }

    private CategoryCreateDataPanel getCategoryCreateDataPanel() {
        return (CategoryCreateDataPanel)this.getEditPanel();
    }

    @Override
    protected String getTitle() {
        return ((AlgorithmsManager)this.getApplication()).getString("CommonEditTabbedPanel.tab.info.basic");
    }

    @Override
    public boolean wasModified() {
        return this.isEditing;
    }
}

