/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.client.applications.algorithmsmanager.versiontree.AbstractFileInfoNode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.CopyFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ExportDocumentationFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.PasteFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.RemoveDocumentationFiles;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.DocumentationPathFactory;
import java.awt.datatransfer.DataFlavor;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import tecgraf.javautils.core.lng.LNG;

final class DocumentationFileNode
extends AbstractFileInfoNode {
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(DocumentationFileNode.class, DocumentationFileNode.class.getSimpleName());

    protected DocumentationFileNode(final VersionTree tree, final AlgorithmVersionInfo version, FileInfo file) {
        super(tree, version, file, new AbstractFileInfoNode.IChildrenFactory(){

            @Override
            public AbstractFileInfoNode createNode(FileInfo file) {
                return new DocumentationFileNode(tree, version, file);
            }
        }, false);
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new CopyFile(this.getTree(), LNG.get((String)"algomanager.menu.doc.copy")))));
        if (this.getFile().isDirectory()) {
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new PasteFile(this.getTree(), LNG.get((String)"algomanager.menu.doc.paste"), DATA_FLAVOR))));
        }
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new RemoveDocumentationFiles(this.getTree(), this.getVersion(), this.getSelectedFiles()))));
        if (!this.getFile().isDirectory()) {
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new ExportDocumentationFile(this.getTree(), this.getVersion(), this.getFile()))));
        }
        return popupMenu;
    }

    @Override
    public DataFlavor getDataFlavor() {
        return DATA_FLAVOR;
    }

    @Override
    protected final IPathFactory createSourcePathFactory(AbstractFileInfoNode.DataTransferObject dto) {
        AlgorithmVersionInfo sourceVersion = dto.getVersion();
        return new DocumentationPathFactory(sourceVersion);
    }

    @Override
    protected final IPathFactory createTargetPathFactory() {
        return new DocumentationPathFactory(this.getVersion());
    }
}

