/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.fileexchanger.logic;

import csbase.client.applications.fileexchanger.logic.BlockSize;
import csbase.client.applications.fileexchanger.logic.ExchangeMode;
import csbase.client.applications.fileexchanger.logic.ExchangeState;
import csbase.client.applications.fileexchanger.logic.ExchangeThread;
import csbase.client.applications.fileexchanger.logic.ExchangeType;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;

public abstract class Exchange {
    private final File localFile;
    private ClientProjectFile remoteFile;
    private final ClientProjectFile remoteDir;
    private final CommonClientProject project;
    private final ExchangeType type;
    private long startTime;
    private long currentTime;
    private final long creationTime;
    private Exception exception;
    private ExchangeThread thread;
    private long totalTransferSize;
    private long currentTransferSize;
    private ExchangeState state;
    private final ArrayList<Point2D.Double> points = new ArrayList();
    private boolean isAlreadyPinged;
    private final ExchangeMode transferMode;
    private final BlockSize blockSize;

    public final BlockSize getBlockSize() {
        return this.blockSize;
    }

    public final long getTotalTransferSize() {
        return this.totalTransferSize;
    }

    public void setTotalTransferSize(long totalTransferSize) {
        this.totalTransferSize = totalTransferSize;
    }

    public final synchronized long getCurrentTransferSize() {
        return this.currentTransferSize;
    }

    public final synchronized void addCurrentTransferSize(long size) {
        this.currentTransferSize += size;
        this.currentTime = System.currentTimeMillis();
        this.isAlreadyPinged = false;
    }

    public final Exception getException() {
        return this.exception;
    }

    public final File getLocalFile() {
        return this.localFile;
    }

    public final ClientProjectFile getRemoteFile() {
        return this.remoteFile;
    }

    public void setRemoteFile(ClientProjectFile remoteFile) {
        this.remoteFile = remoteFile;
    }

    public final ClientProjectFile getRemoteDir() {
        return this.remoteDir;
    }

    public final CommonClientProject getProject() {
        return this.project;
    }

    public final ExchangeType getType() {
        return this.type;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final synchronized ExchangeState getState() {
        return this.state;
    }

    public final synchronized void start() {
        if (this.state == ExchangeState.PAUSED) {
            this.state = ExchangeState.RUNNING;
            return;
        }
        if (this.state == ExchangeState.QUEUED) {
            this.currentTime = this.startTime = System.currentTimeMillis();
            this.thread = this.createThread();
            this.thread.start();
            this.state = ExchangeState.RUNNING;
        }
    }

    public final synchronized void pause() {
        if (this.state != ExchangeState.RUNNING) {
            return;
        }
        this.state = ExchangeState.PAUSED;
    }

    public final synchronized void resume() {
        if (this.state != ExchangeState.PAUSED) {
            return;
        }
        this.state = ExchangeState.RUNNING;
    }

    public final synchronized void interrupt() {
        if (this.state == ExchangeState.QUEUED || this.state == ExchangeState.CREATED) {
            this.state = ExchangeState.INTERRUPTED;
            return;
        }
        if (this.state != ExchangeState.RUNNING && this.state != ExchangeState.PAUSED) {
            return;
        }
        this.ping();
        this.state = ExchangeState.INTERRUPTED;
        this.thread.interrupt();
        this.thread = null;
        this.exception = null;
        this.currentTime = System.currentTimeMillis();
    }

    public synchronized void signalEnded(Exception ex) {
        this.exception = ex;
        this.thread = null;
        this.currentTime = System.currentTimeMillis();
        if (this.state == ExchangeState.INTERRUPTED) {
            this.exception = null;
            return;
        }
        this.ping();
        this.state = ex == null ? ExchangeState.FINISHED : ExchangeState.ERROR;
    }

    public final synchronized double getProgress() {
        if (this.state == ExchangeState.FINISHED) {
            return 1.0;
        }
        return (double)this.currentTransferSize / (double)this.totalTransferSize;
    }

    public final synchronized long getElapsedTime() {
        if (this.state == ExchangeState.QUEUED) {
            return -1L;
        }
        long dt = this.currentTime - this.startTime;
        return dt;
    }

    public final synchronized long getTotalTime() {
        if (this.state != ExchangeState.RUNNING) {
            return -1L;
        }
        double ratio = (double)this.currentTransferSize / (double)this.totalTransferSize;
        long dt = this.getElapsedTime();
        return (long)((double)dt / ratio);
    }

    public final synchronized long getRemainingTime() {
        if (this.state != ExchangeState.RUNNING) {
            return -1L;
        }
        long diff = this.getTotalTime() - this.getElapsedTime();
        return diff;
    }

    public final synchronized double getInstantTransferRateMbSec() {
        if (this.state != ExchangeState.RUNNING) {
            return -1.0;
        }
        if (this.points == null) {
            return -2.0;
        }
        int size = this.points.size();
        if (size < 2) {
            return -3.0;
        }
        Point2D.Double pt1 = this.points.get(size - 1);
        Point2D.Double pt2 = this.points.get(size - 2);
        double dt = pt2.x - pt1.x;
        double ds = pt2.y - pt1.y;
        double rate = ds / dt;
        return rate;
    }

    public final synchronized double getGlobalTransferRateMbSec() {
        long dt = this.getElapsedTime();
        double tSec = (double)dt / 1000.0;
        double sizeMb = (double)this.currentTransferSize / 1024.0 / 1024.0;
        if (Math.abs(tSec) <= 1.0E-7) {
            return 0.0;
        }
        return sizeMb / tSec;
    }

    public synchronized void signalAdded() {
        this.state = ExchangeState.QUEUED;
    }

    public synchronized void signalError() {
        this.state = ExchangeState.ERROR;
    }

    public synchronized void signalRemoved() {
        this.state = ExchangeState.REMOVED;
    }

    public final String getLabel() {
        if (this.getRemoteFile() != null) {
            return this.getRemoteFile().getName();
        }
        return "";
    }

    public final synchronized void ping() {
        if (this.isAlreadyPinged) {
            return;
        }
        double time = (double)this.getElapsedTime() / 1000.0;
        double sz = (double)this.currentTransferSize / 1024.0 / 1024.0;
        Point2D.Double pt = new Point2D.Double(time, sz);
        this.points.add(pt);
        this.isAlreadyPinged = true;
    }

    public final synchronized ArrayList<Point2D.Double> getPoints() {
        return this.points;
    }

    public final ExchangeMode getTransferMode() {
        return this.transferMode;
    }

    public Exchange(ExchangeType type, ExchangeMode transferMode, BlockSize blockSize, File localFile, ClientProjectFile remoteFile, ClientProjectFile remoteDir, long totalTransferSize, CommonClientProject project) {
        this.blockSize = blockSize;
        this.transferMode = transferMode;
        this.type = type;
        this.localFile = localFile;
        this.remoteDir = remoteDir;
        this.remoteFile = remoteFile;
        this.project = project;
        this.creationTime = System.currentTimeMillis();
        this.startTime = 0L;
        this.currentTime = 0L;
        this.totalTransferSize = totalTransferSize;
        this.currentTransferSize = 0L;
        this.state = ExchangeState.CREATED;
    }

    protected abstract ExchangeThread createThread();

    public String getRemoteFilePath() {
        if (this.remoteFile != null) {
            return this.remoteFile.getStringPath();
        }
        return this.remoteDir.getStringPath() + File.separator + this.localFile.getName();
    }
}

