/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;
import csbase.client.applications.projectsmanager.panels.AbstractProjectManagerInfoPanel;
import csbase.client.applications.projectsmanager.proxy.RetrieveUsersTask;
import csbase.client.applications.projectsmanager.usersearch.UserDialog;
import csbase.logic.ProjectPermissions;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

class SingleSelectionPanel
extends AbstractProjectManagerInfoPanel {
    private ProjectsManagerData projectsManagerData;
    private JTextField projectNameTextField;
    private JTextField projectOwnerTextField;
    private JTextField projectDescriptionTextField;
    private JTextField accessModeTextField;
    private JButton sharedUsersButton;

    SingleSelectionPanel(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    void initComponents() {
        this.projectNameTextField = new JTextField(20);
        this.projectOwnerTextField = new JTextField(20);
        this.projectDescriptionTextField = new JTextField(80);
        this.accessModeTextField = new JTextField(20);
        this.projectNameTextField.setEditable(false);
        this.projectOwnerTextField.setEditable(false);
        this.projectDescriptionTextField.setEditable(false);
        this.accessModeTextField.setEditable(false);
        this.sharedUsersButton = new JButton();
        this.sharedUsersButton.setToolTipText(this.getString("SingleSelectionPanel.shared.users.button.tooltip"));
        final ProjectsManager projectsManager = this.getProjectsManager();
        final ApplicationFrame frame = projectsManager.getApplicationFrame();
        this.sharedUsersButton.setAction(new ProjectsManagerAction(projectsManager){

            @Override
            public void actionDone() throws Exception {
                Set<Object> usersROIds = SingleSelectionPanel.this.projectsManagerData.getUsersRO();
                Set<Object> usersRWIds = SingleSelectionPanel.this.projectsManagerData.getUsersRW();
                TreeSet<Object> users = new TreeSet<Object>();
                users.addAll(usersROIds);
                users.addAll(usersRWIds);
                RetrieveUsersTask rut = new RetrieveUsersTask(projectsManager, users);
                rut.execute(frame, this.getString("SingleSelectionPanel.title"), this.getString("SingleSelectionPanel.message"));
                if (rut.wasCancelled()) {
                    String err = this.getString("SingleSelectionPanel.cancelled.message");
                    rut.showError(err);
                    return;
                }
                if (!rut.getStatus()) {
                    Exception exception = rut.getError();
                    throw exception;
                }
                List userList = (List)rut.getResult();
                if (userList == null) {
                    StandardDialogs.showInfoDialog((Component)projectsManager.getApplicationFrame(), (String)this.getString("SingleSelectionPanel.shared.users.read.error.title"), (Object)this.getString("SingleSelectionPanel.shared.users.read.error.message"));
                    return;
                }
                UserDialog.showProjectUsersDialog(projectsManager.getApplicationFrame(), userList, usersROIds, usersRWIds);
            }
        });
        this.sharedUsersButton.setIcon(ApplicationImages.ICON_FIND_USER_16);
        GUIUtils.trimImageButton((AbstractButton)this.sharedUsersButton);
        this.sharedUsersButton.setEnabled(false);
    }

    @Override
    void buildPanel() {
        JLabel projectNameLabel = new JLabel(this.getString("SingleSelectionPanel.project.name.label"));
        JLabel projectOwnerLabel = new JLabel(this.getString("SingleSelectionPanel.project.owner.label"));
        JLabel projectDescriptionLabel = new JLabel(this.getString("SingleSelectionPanel.project.description.label"));
        JLabel accessModeLabel = new JLabel(this.getString("SingleSelectionPanel.project.access.mode.label"));
        int T = 12;
        int TI = 6;
        int L = 12;
        int R = 11;
        this.setLayout(new GridBagLayout());
        this.add((Component)projectNameLabel, new GBC(0, 0).west().insets(12, 12, 0, 11));
        this.add((Component)this.projectNameTextField, new GBC(1, 0).west().insets(12, 12, 0, 11).horizontal());
        this.add((Component)projectOwnerLabel, new GBC(2, 0).west().insets(6, 12, 0, 11));
        this.add((Component)this.projectOwnerTextField, new GBC(3, 0).west().insets(6, 12, 0, 11).horizontal());
        this.add((Component)accessModeLabel, new GBC(0, 1).west().insets(6, 12, 0, 11));
        this.add((Component)this.accessModeTextField, new GBC(1, 1).west().insets(6, 12, 0, 11).horizontal());
        this.add((Component)this.sharedUsersButton, new GBC(2, 1).west().insets(6, 12, 0, 11).width(1));
        this.add((Component)projectDescriptionLabel, new GBC(0, 2).west().insets(6, 12, 0, 11));
        this.add((Component)this.projectDescriptionTextField, new GBC(1, 2).west().insets(6, 12, 0, 11).width(3).horizontal());
        BorderUtil.setTitledBorder((JComponent)this, (String)this.getString("SingleSelectionPanel.project.info.title"));
        this.validate();
        this.repaint();
    }

    @Override
    void updateFields() {
        String projectName = String.valueOf(this.projectsManagerData.getProjectName());
        this.projectNameTextField.setText(projectName);
        String description = this.projectsManagerData.getProjectDescription();
        this.projectDescriptionTextField.setText(description);
        Object ownerId = this.projectsManagerData.getOwnerId();
        String ownerName = this.projectsManagerData.getOwnerName();
        this.projectOwnerTextField.setText(ownerId + " (" + ownerName + ")");
        String accessModeMessage = this.getAccessModeMessage();
        this.accessModeTextField.setText(accessModeMessage);
        if (this.projectsManagerData.getScope() == ProjectsManagerScope.SHARED) {
            this.sharedUsersButton.setEnabled(true);
        } else {
            this.sharedUsersButton.setEnabled(false);
        }
    }

    @Override
    public void clearFields() {
        this.projectNameTextField.setText(null);
        this.projectDescriptionTextField.setText(null);
        this.projectOwnerTextField.setText(null);
        this.accessModeTextField.setText(null);
    }

    private String getAccessModeMessage() {
        ProjectsManagerScope scope = this.projectsManagerData.getScope();
        if (scope == null) {
            return this.getString("SingleSelectionPanel.invalid.access.mode.message");
        }
        switch (scope) {
            case PRIVATE: 
            case NOT_APPLICABLE: 
            case SHARED: {
                return scope.getTitle();
            }
            case PUBLIC: {
                StringBuilder sb = new StringBuilder(scope.getTitle());
                sb.append(" (");
                ProjectPermissions.SharingType sharingType = this.projectsManagerData.getSharingType();
                if (sharingType == ProjectPermissions.SharingType.ALL_RO) {
                    sb.append(this.getString("SingleSelectionPanel.readonly.access.mode.message"));
                } else if (sharingType == ProjectPermissions.SharingType.ALL_RW) {
                    sb.append(this.getString("SingleSelectionPanel.read.write.access.mode.message"));
                } else {
                    throw new RuntimeException("tipo inconsistente de compartilhamento: " + sharingType.name());
                }
                sb.append(')');
                return sb.toString();
            }
        }
        throw new RuntimeException("escopo inv\u00e1lido: " + scope.name());
    }

    public void setProjectsManagerData(ProjectsManagerData projectsManagerData) {
        this.projectsManagerData = projectsManagerData;
        this.updateFields();
    }
}

