/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels.renderers;

import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.logic.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TableDateRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null) {
            return component;
        }
        JLabel label = (JLabel)component;
        Date date = (Date)value;
        label.setHorizontalAlignment(0);
        long time = date.getTime();
        if (time == 0L) {
            label.setText("-");
            label.setForeground(Color.gray);
            String tooltipTag = "TableDateRenderer.no.time.tooltip";
            String tooltip = ProjectsManagerUI.getString("TableDateRenderer.no.time.tooltip");
            label.setToolTipText(tooltip);
        } else {
            label.setForeground(Color.black);
            label.setIcon(null);
            String text = Utilities.getFormattedDate((long)time);
            label.setText(text);
        }
        return label;
    }
}

