/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.ClientLocalFile;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.RemoteTask;
import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectFileTypeComboBox;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;

public class DirectoryCreationDialog {
    protected DesktopComponentDialog dialog;
    protected Window owner;
    protected JTextField dirNameText;
    protected JButton createButton;
    protected ClientFile directory;
    private ProjectFileTypeComboBox dirTypeComboBox;

    public static void show(Window owner, ClientFile directory) {
        new DirectoryCreationDialog(owner, directory);
    }

    protected DesktopComponentDialog makeDialog() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.makeNamePanel(), "Center");
        mainPanel.add((Component)this.makeButtonPanel(), "South");
        String title = this.getTitle();
        DesktopComponentDialog dlg = new DesktopComponentDialog(this.owner, title);
        dlg.getContentPane().add(mainPanel);
        dlg.pack();
        dlg.center(this.owner);
        dlg.getRootPane().setDefaultButton(this.createButton);
        dlg.setResizable(false);
        return dlg;
    }

    private JPanel makeNamePanel() {
        JLabel dirNameLabel = new JLabel(LNG.get((String)"PRJ_NAME"));
        this.dirNameText = new JTextField(20);
        JLabel dirTypeLabel = new JLabel(LNG.get((String)"PRJ_FILE_TYPE"));
        this.dirTypeComboBox = new ProjectFileTypeComboBox(ProjectFileTypeComboBox.Mode.DIRECTORY_ONLY, false);
        this.dirTypeComboBox.selectTypeCode("DIRECTORY_TYPE");
        JComponent[][] components = new JComponent[][]{{dirNameLabel, this.dirNameText}, {dirTypeLabel, this.dirTypeComboBox}};
        this.dirNameText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String name = DirectoryCreationDialog.this.dirNameText.getText().trim();
                if (name.isEmpty()) {
                    DirectoryCreationDialog.this.createButton.setEnabled(false);
                } else {
                    DirectoryCreationDialog.this.createButton.setEnabled(true);
                }
            }
        });
        return GUIUtils.createBasicGridPanel((JComponent[][])components);
    }

    protected JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        this.createButton = new JButton(LNG.get((String)"PRJ_CREATION"));
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryCreationDialog.this.handleAction();
            }
        });
        this.createButton.setEnabled(false);
        JButton cancelButton = new JButton(LNG.get((String)"PRJ_CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryCreationDialog.this.dialog.close();
            }
        });
        JComponent[] buttons = new JComponent[]{this.createButton, cancelButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        panel.add(this.createButton);
        panel.add(cancelButton);
        return panel;
    }

    protected String getTitle() {
        return ClientUtilities.addSystemNameToTitle(LNG.get((String)"project.directory_creation_title"));
    }

    private void handleAction() {
        final String name = this.dirNameText.getText().trim();
        final String typeCode = this.dirTypeComboBox.getSelectedTypeCode();
        String title = this.getTitle();
        final String prefix = this.getClass().getSimpleName();
        if (!ClientUtilities.isValidFileName(name)) {
            String err = LNG.get((String)(prefix + ".dir.name.error"));
            StandardErrorDialogs.showErrorDialog(this.owner, title, err);
            return;
        }
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                switch (DirectoryCreationDialog.this.directory.getClientFileType()) {
                    case LOCAL: {
                        ClientLocalFile parent = (ClientLocalFile)DirectoryCreationDialog.this.directory;
                        File newDir = new File(parent.getStringPath(), name);
                        if (newDir.mkdir()) break;
                        String err = LNG.get((String)(prefix + ".create.dir.error"), (Object[])new Object[]{name});
                        throw new ClientException(err);
                    }
                    case REMOTE: {
                        ((ClientProjectFile)DirectoryCreationDialog.this.directory).createFile(name, typeCode);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("File type does not support directory creation");
                    }
                }
            }
        };
        Object[] args = new String[]{name};
        String taskMessage = LNG.get((String)(prefix + ".create.dir.task"), (Object[])args);
        if (task.execute(this.dialog, title, taskMessage)) {
            this.dialog.close();
        }
    }

    private DirectoryCreationDialog(Window owner, ClientFile directory) {
        this.owner = owner;
        this.directory = directory;
        this.dialog = this.makeDialog();
        this.dialog.setVisible(true);
    }
}

