/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.action.CommonProjectAction;
import csbase.logic.ClientProjectFile;
import csbase.remote.ClientRemoteLocator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class FileUnlockAction
extends CommonProjectAction {
    public FileUnlockAction(ProjectFileContainer container) {
        super(container);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final ClientProjectFile file = this.getSelectedFile();
        String fileName = file.getName();
        String title = LNG.get((String)"FileUnlockAction.title");
        String text = String.format(LNG.get((String)"FileUnlockAction.confirmation"), fileName);
        int option = StandardDialogs.showOptionDialog((Component)this.getWindow(), (String)title, (Object)text, (Object[])new String[]{LNG.get((String)"FileUnlockAction.button.unlock"), LNG.get((String)"FileUnlockAction.button.cancel")});
        if (option != 0) {
            return;
        }
        RemoteTask<Integer> task = new RemoteTask<Integer>(){

            protected void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.projectService.forceReleaseLock(file.getProjectId(), file.getPath()));
            }
        };
        boolean result = task.execute(this.getWindow(), title, String.format(LNG.get((String)"FileUnlockAction.info.unlock"), fileName));
        if (result && (Integer)task.getResult() != 0) {
            this.showError(title, String.format(LNG.get((String)"FileUnlockAction.error.unlock"), fileName));
        }
    }

    @Override
    public String getName() {
        return LNG.get((String)"FileUnlockAction.name");
    }
}

