/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.ClientServerManager;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTree;
import csbase.client.project.action.ProjectAction;
import csbase.exception.CSBaseRuntimeException;
import csbase.exception.PermissionException;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.remote.ClientRemoteLocator;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tecgraf.javautils.core.lng.LNG;

public class ProjectCloseAction
extends ProjectAction
implements WindowListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        this.close();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.close();
    }

    public boolean close() {
        Exception e;
        final CommonClientProject project = this.getCurrentProject();
        if (project == null) {
            return true;
        }
        ApplicationManager appMgr = ApplicationManager.getInstance();
        Hashtable<String, Vector<ApplicationType>> runningApps = appMgr.getRunningApplications();
        Enumeration<String> appKeys = runningApps.keys();
        while (appKeys.hasMoreElements()) {
            String key = appKeys.nextElement();
            Vector<ApplicationType> originalVector = runningApps.get(key);
            Vector copyVector = (Vector)originalVector.clone();
            if (copyVector == null) continue;
            for (int i = 0; i < copyVector.size(); ++i) {
                ApplicationType app = (ApplicationType)copyVector.get(i);
                ApplicationRegistry appReg = appMgr.getApplicationRegistry(app.getId());
                if (!appReg.requireProject() || app.closeApplication()) continue;
                return false;
            }
        }
        this.closeProject();
        Object ownerID = User.getLoggedUser().getId();
        CommonClientProject currentProject = this.getCurrentProject();
        if (currentProject.userHasAccessRW(ownerID) && !this.saveProjectModifications()) {
            return false;
        }
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                project.close(true);
            }

            @Override
            public void handleServerError(CSBaseRuntimeException cserror) {
                if (!(cserror instanceof PermissionException)) {
                    super.handleServerError(cserror);
                }
            }
        };
        if (!task.execute(this.getWindow(), LNG.get((String)"PRJ_PROJECT_CLOSE_TITLE"), LNG.get((String)"PRJ_WAITING_CLOSE_PROJECT")) && !((e = task.getError()) instanceof PermissionException)) {
            return false;
        }
        this.getProjectTree().resetProject();
        return true;
    }

    private boolean saveProjectModifications() {
        Exception e;
        RemoteTask<Void> saveProjectTask = new RemoteTask<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void performTask() throws Exception {
                try {
                    ProjectCloseAction.this.getCurrentProject().modify();
                }
                finally {
                    ClientRemoteLocator.server.setServerSessionProperty(ClientServerManager.getInstance().getSession().getKey(), "current_project", null);
                }
            }
        };
        return saveProjectTask.execute(this.getWindow(), LNG.get((String)"PRJ_PROJECT_CLOSE_TITLE"), LNG.get((String)"PRJ_WAITING_CLOSE_PROJECT")) || (e = saveProjectTask.getError()) instanceof PermissionException;
    }

    @Override
    public String getName() {
        return LNG.get((String)"PRJ_CLOSE");
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public ProjectCloseAction(ProjectTree treeView) {
        super(treeView);
    }
}

