package csbase.client.applications.sgamonitor.actions;

import java.awt.event.ActionEvent;
import java.util.List;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.sgamonitor.SGAMonitor;
import csbase.client.remote.srvproxies.SGAProxy;
import csbase.logic.SGASet;

/**
 * Ao que reinicia todos os SGAs selecionados.
 * 
 * @author Tecgraf
 */
public class RestartSGAClusterAction extends
  AbstractSimpleApplicationAction<SGAMonitor> {

  /**
   * Construtor padro.
   * 
   * @param application - aplicao na qual esta ao est sendo executada.
   */
  public RestartSGAClusterAction(SGAMonitor application) {
    super(application, ApplicationImages.ICON_RESET_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {

    SGAMonitor application = getApplication();
    List<SGASet> selectedSGAs = application.getSelectedSGAs();

    if (confirmRestart(selectedSGAs)) {
      for (SGASet sga : selectedSGAs) {
        SGAProxy.restartSGA(sga.getName());
      }
    }
  }

  /**
   * Cria a interface que pergunta ao usurio se ele deseja reiniciar os SGAs.
   * 
   * @param selectedSGAs - SGAs selecionados.
   * @return <code>true</code> se o usurio confirmar, <code>false</code> caso
   *         contrrio.
   */
  private boolean confirmRestart(List<SGASet> selectedSGAs) {
    Application app = getApplication();
    ApplicationFrame frame = app.getApplicationFrame();

    Object[] options =
      { app.getString("button.restart"), app.getString("button.cancel") };

    String title = app.getString("confirm.view.title");
    String question = app.getString("question.restart.all");

    if (selectedSGAs.size() == 1) {
      SGASet sga = selectedSGAs.get(0);
      question =
        String.format(app.getString("question.restart.one"), sga.getName());
    }

    int opt = StandardDialogs.showOptionDialog(frame, title, question, options);
    return (opt == 0);
  }
}
