/*
 * $Id: FirstPageAction.java 72790 2008-02-15 20:05:47Z clinio $
 */
package csbase.client.util.gui.log.actions;

import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.util.event.EventListener;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.LogPanel.PagingEvent;
import csbase.client.util.gui.log.actions.core.AbstractLogFileAction;

/**
 * Pede para que o painel de log mostre a primeira pgina. Caso a pgina sendo
 * mostrada pelo painel seja a primeira, esta ao se desabilita.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class FirstPageAction extends AbstractLogFileAction {

  /**
   * Construtor
   * 
   * @param logPanel o painel de log associado a ao.
   */
  public FirstPageAction(final LogPanel logPanel) {
    super(logPanel, ApplicationImages.ICON_PAGE_FIRST_16);
    logPanel.addPagingEventListener(new EventListener<LogPanel.PagingEvent>() {
      public void eventFired(PagingEvent event) {
        long page = event.getPageNumber();
        if (LogPanel.FIRST_PAGE >= page) {
          setEnabled(false);
        }
        else {
          setEnabled(true);
        }
      }
    });
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) throws Exception {
    getLogPanel().goToPage(LogPanel.FIRST_PAGE);
    getLogPanel().getTextArea().goToHead();
  }
}
