/*
 * $Id$
 */

package csbase.client.applicationmanager;

import java.util.Hashtable;

/**
 * Mtodos utilitrios
 * 
 * @author Tecgraf/PUC-Rio
 */
final class Utilities {

  /**
   * Busca um valor inteiro na hash
   * 
   * @param table a hash
   * @param key a chave
   * @param defaultValue o valor default
   * @return o valor associado
   */
  static int getIntegerFromHash(Hashtable table, Object key, int defaultValue) {
    Object value = table.get(key);
    if ((value == null) || !(value instanceof Integer)) {
      return defaultValue;
    }
    return ((Integer) value).intValue();
  }

  /**
   * Busca um valor booleano na hash
   * 
   * @param table a hash
   * @param key a chave
   * @param defaultValue o valor default
   * @return o valor associado
   */
  static boolean getBooleanFromHash(Hashtable table, Object key,
    boolean defaultValue) {
    Object value = table.get(key);
    if ((value == null) || !(value instanceof Boolean)) {
      return defaultValue;
    }
    return ((Boolean) value).booleanValue();
  }


 
}
