package csbase.client.applications.algorithmsmanager.actions;

import javax.swing.ImageIcon;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.dialogs.CategoryManagementPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CategorySelectionPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonManagementPanel;

/**
 * Essa classe representa a ao para gerenciamento de categorias de algoritmos,
 * onde  criado o respectivo painel para realizar o gerenciamento sobre
 * categorias.
 * 
 */
public class CategoryManagementAction extends CommonManagementAction {
  /**
   * Constri a ao de gerncia de categorias de algoritmos.
   * 
   * @param application referncia para a aplicao
   * @param icon imagem da ao
   */
  public CategoryManagementAction(AlgorithmsManager application, ImageIcon icon) {
    super(application, icon);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected CategoryManagementPanel getManagePanel() {
    return (CategoryManagementPanel) super.getManagePanel();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public CategorySelectionPanel getSelectionPanel() {
    return (CategorySelectionPanel) super.getSelectionPanel();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void selectInitialData() {
    getSelectionPanel().selectRootNode();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected CommonManagementPanel createManagementPanel(
    CommonManagementAction commonManagementAction) {
    return new CategoryManagementPanel(this);
  }
}
