package csbase.client.applications.algorithmsmanager.versiontree;

import java.util.LinkedList;

import javax.swing.table.AbstractTableModel;

/**
 * Modelo para a tabela de propriedade dos algoritmos. Esse modelo possui campos
 * editveis e notifica listeners quando h alguma alterao nos valores de seus
 * campos.
 * 
 * @author valeria
 *
 */
public class AlgorithmPropertiesTableModel extends AbstractTableModel {
  private LinkedList<AlgorithmPropertiesTableListener> listenerList;
  private static final long serialVersionUID = 1L;
  private String[] columnNames;
  private Object[][] data;

  public AlgorithmPropertiesTableModel(Object[][] data, String[] columnNames) {
    super();
    this.data = data;
    this.columnNames = columnNames;
    listenerList = new LinkedList<>();
  }

  public int getRowCount() {
    return data.length;
  }

  public int getColumnCount() {
    return columnNames.length;
  }
  
  public String getColumnName(int column) {
    return columnNames[column];
  }

  public Object getValueAt(int rowIndex, int columnIndex) {
    return data[rowIndex][columnIndex];
  }
  
  public boolean isCellEditable(int rowIndex, int columnIndex) {
    return columnIndex > 0;
  }

  public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    data[rowIndex][columnIndex] = aValue;
    fireTableCellUpdated(rowIndex, columnIndex);
    for(int i = 0; i < listenerList.size(); i++)
      listenerList.get(i).wasModified();
  }
  
  public void addListener(AlgorithmPropertiesTableListener algorithmTable) {
    listenerList.add(algorithmTable);
  }
}
