/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.actions;

import java.awt.event.ActionEvent;

import csbase.client.algorithms.commands.newview.CommandViewFactory;
import csbase.client.algorithms.commands.newview.NewCommandViewUtils;
import csbase.client.algorithms.commands.view.AlgorithmCommandViewFactory;
import csbase.client.algorithms.commands.view.TabType;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.commandsmonitor.CommandsMonitor;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;

/**
 * Mostra a sada padro de um nico comando selecionado.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class ShowCommandLogAction extends AbstractCommandsAction {

  /**
   * Construtor.
   * 
   * @param application Aplicao que detm essa ao.
   */
  public ShowCommandLogAction(CommandsMonitor application) {
    super(application, false, ApplicationImages.ICON_VIEWLOG_16);
  }

  /**
   * Filtro indicando que esta ao aceita qualquer comando que no esteja no
   * estado {@link CommandStatus#SCHEDULED agendado} ou no estado
   * {@link CommandStatus#SYSTEM_FAILURE falha no sistema}. {@inheritDoc}
   */
  @Override
  protected boolean accept(CommandInfo command) {
    final DesktopFrame desktop = DesktopFrame.getInstance();
    boolean hasOpenProjects = (desktop.getProject() != null);
    return hasOpenProjects && command.getStatus() != CommandStatus.SCHEDULED
      && command.getStatus() != CommandStatus.SYSTEM_FAILURE;
  }

  /**
   * Mostra a sada padro do comando selecionado. {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    DesktopComponentFrame owner = getApplication().getApplicationFrame();
    CommandInfo command = getSelectedCommand();
    if (NewCommandViewUtils.useNewVersion()) {
      CommandViewFactory.showCommandView(command, owner, NewCommandViewUtils
        .getNewTabType(TabType.LOG));
    }
    else {
      AlgorithmCommandViewFactory.showView(owner, command, TabType.LOG);
    }
  }
}
