/*
 * $Id$
 */
package csbase.client.applications.diskinfo;

import java.awt.BorderLayout;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.util.Rotation;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.Application;
import csbase.client.remote.srvproxies.DiskUsageProxy;

/**
 * A classe <code>DiskUserPanel</code> modela o painel de monitorao de uso de
 * disco pelos usurios.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DiskUserPanel extends DiskInfoPanel {

  /**
   * Indicativo de exibio de usurios sem espao ocupado.
   */
  private final boolean showsNoSpaceUser;

  /**
   * Painel que contm o grfico
   */
  final private JFreeChart graph;

  /**
   * {@inheritDoc}
   */
  @Override
  final public void rotatePie() {
    final PiePlot pieplot = (PiePlot) graph.getPlot();
    double angle = pieplot.getStartAngle() + 1;
    pieplot.setStartAngle(angle);
    if (angle == 360) {
      angle = 0;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public void refreshPie(final Application app) {
    final Hashtable<Object, Double> hash = DiskUsageProxy.getUsersList();
    final DefaultPieDataset dataset = new DefaultPieDataset();
    boolean emptyProjects = true;
    if (hash != null) {
      for (final Enumeration<Object> en = hash.keys(); en.hasMoreElements();) {
        final Object id = en.nextElement();
        final double mega = hash.get(id);
        if (mega > 0 || showsNoSpaceUser) {
          dataset.setValue(id.toString(), mega);
          emptyProjects = false;
        }
      }
    }
    if (emptyProjects) {
      dataset.setValue("", 0);
    }
    final PiePlot pieplot = (PiePlot) graph.getPlot();
    pieplot.setNoDataMessage(app
      .getString("DiskUserPanel.get.usage.failed.error"));
    final String labelFmt = app.getString("panel.user.label.format");
    final NumberFormat sizeFormatter =
      NumberFormat.getNumberInstance(LNG.getLocale());
    sizeFormatter.setMinimumFractionDigits(2);
    sizeFormatter.setMaximumFractionDigits(2);
    final NumberFormat percFormatter = NumberFormat.getPercentInstance();
    pieplot.setLabelGenerator(new StandardPieSectionLabelGenerator(labelFmt,
      sizeFormatter, percFormatter));
    pieplot.setDirection(Rotation.CLOCKWISE);
    pieplot.setForegroundAlpha(0.7F);
    pieplot.setBackgroundPaint(null);
    pieplot.setOutlinePaint(null);
    pieplot.setDataset(dataset);
    pieplot.setCircular(true);
  }

  /**
   * Construtor do painel DiskUserPanel.
   * 
   * @param app aplicao que inicia o painel
   */
  public DiskUserPanel(final Application app) {
    final String name = app.getString("panel.user.disk");
    final String tabName = app.getString("panel.user.disk.tab");
    graph = ChartFactory.createPieChart3D(name, null, false, false, false);
    final ChartPanel chartPanel = new ChartPanel(graph);
    chartPanel.setPopupMenu(null);
    this.setLayout(new BorderLayout());
    this.add(chartPanel, BorderLayout.CENTER);
    this.setName(tabName);

    this.showsNoSpaceUser =
      app.getBooleanSpecificProperty("showsNoSpaceUsers", true);
    refreshPie(app);
  }
}
