package csbase.client.applications.fileexchanger.logic;

import csbase.client.applications.fileexchanger.FileExchangerUI;

/**
 * Tamanhos padronizados de chunk.
 * 
 * @author Tecgraf/PUC-Rio
 */
public enum BlockSize {

  /**
   * Mnimo
   */
  TINY(16),

  /**
   * Pequeno
   */
  SMALL(48),

  /**
   * Normal
   */
  NORMAL(256),

  /**
   * Normal
   */
  BIG(512),

  /**
   * Grande
   */
  HUGE(1024);

  /**
   * bytes para Mb
   */
  static private final int KB = 1024;

  /**
   * Tamanho do chunk em bytes
   */
  final private int size;

  /**
   * Consulta o texto da descrio.
   * 
   * @return o texto
   */
  public String getName() {
    final String tag = "BlockSize." + toString() + ".name";
    return FileExchangerUI.getString(tag);
  }

  /**
   * Consulta tamanho em bytes
   * 
   * @return o valor
   */
  public final int getSize() {
    return size;
  }

  /**
   * Consulta tamanho em bytes
   * 
   * @return o valor
   */
  public final int getSizeKb() {
    return size / KB;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public String toString() {
    return super.toString();
  }

  /**
   * Construtor
   * 
   * @param sizeKb tamanho em kB
   */
  private BlockSize(final int sizeKb) {
    this.size = sizeKb * KB;
  }
}
