/*
 * $Id$
 */

package csbase.client.applications.projectsmanager.panels;

import javax.swing.JPanel;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;

/**
 * Painel genrico da aplicao ProjectsManager.
 * 
 * @author jnlopes
 * 
 */
public abstract class ProjectsManagerPanel extends JPanel {

  /**
   * A aplicao.
   */
  final private ProjectsManager projectsManager;

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public ProjectsManagerPanel(final ProjectsManager projectsManager) {
    this.projectsManager = projectsManager;
  }

  /**
   * Mtodo de busca de uma string de internacionalizao dentro do escopo da
   * ao conforme o padro "<code>NomeDaClasse.TagDesejada</code>"
   * 
   * @param tag tag desejada
   * @return o texto de internacionalizao
   */
  final public String getClassString(final String tag) {
    return ProjectsManagerUI.getClassString(this.getClass(), tag);
  }

  /**
   * Mtodo de busca de uma string de internacionalizao dentro do escopo da
   * ao.
   * 
   * @param tag tag desejada
   * @return o texto de internacionalizao
   */
  final public String getString(final String tag) {
    return ProjectsManagerUI.getString(tag);
  }

  /**
   * Consulta  aplicao.
   * 
   * @return a aplicao
   */
  public ProjectsManager getProjectsManager() {
    return projectsManager;
  }
}
