package csbase.client.applications.projectsmanager.proxy;

import java.util.ArrayList;
import java.util.List;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectAttribute;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;

/**
 * Task que trata a incluso de comentrios pessoais ao histrico de projetos.
 * 
 * @author jnlopes
 */
public class ChangeServerOwnerProjectTask extends
  ProjectsManagerTask<List<ProjectsManagerData>> {

  /**
   * Informaes dos projetos.
   */
  private List<ProjectsManagerData> projects;

  /**
   * Nome do servidor a ser alterado
   */
  private String serverName;

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   * @param projects Informaes dos projetos.
   * @param serverName Nome do servidor a ser alterado.
   */
  public ChangeServerOwnerProjectTask(ProjectsManager projectsManager,
    List<ProjectsManagerData> projects, String serverName) {
    super(projectsManager);
    this.projects = projects;
    this.serverName = serverName;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    List<ProjectsManagerData> list = new ArrayList<ProjectsManagerData>();
    ProjectServiceInterface psi = ClientRemoteLocator.projectService;
    for (int i = 0; i < projects.size(); i++) {
      try {
        CommonClientProject ccp =
          psi.openProject(projects.get(i).getProjectId(), false);
        ccp.setAttribute(ProjectAttribute.SERVER_NAME.getAttributeKey(),
          this.serverName);
        ccp.modify();
        ccp.close(false);
      }
      catch (Exception e) {
        list.add(projects.get(i));
      }
    }
    setResult(list);
  }
}
