/**
 * $Id$
 */
package csbase.client.applications.sgamonitor.columns;

import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGASet;

/**
 * Coluna que indica se o SGA est usando CSFS para transferncia de arquivos.
 * 
 * @author Tecgraf
 */
public class CSFSEnabledColumn extends AbstractConfigurableColumn<SGASet> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   * @param visible - visibilidade da coluna.
   * @param stringProvider - utilizado para obter o nome da coluna
   *        internacionalizada.
   * @param align - alinhamento da coluna.
   */
  public CSFSEnabledColumn(String id, Boolean visible,
    IStringProvider stringProvider, Integer align) {
    super(id, visible, stringProvider, align);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return String.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getString(getId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(SGASet obj) {
    boolean CSFSEnable = obj.isCSFSEnabled();
    return getString("csfs." + Boolean.toString(CSFSEnable));
  }
}
