/*
 * ClientProjectFileType.java
 *
 * $Author$
 * $Revision$ - $Date$
 */
package csbase.client.project;

import java.rmi.RemoteException;
import java.util.Locale;

import javax.swing.ImageIcon;

import csbase.logic.ProjectFileType;
import csbase.logic.ProjectFileTypeInfo;

/**
 * A classe <code>ClientProjectFileType</code> mantm todos os tipos  de
 * arquivos conhecidos pelo sistema.
 *
 * @author Cristina Ururahy
 */
public class ClientProjectFileType extends ProjectFileType {
  /** cone de um arquivo regular */
  private ImageIcon baseIcon;

  /** cone de um arquivo recortado */
  private ImageIcon cutIcon;

  /** cone de um arquivo em construo  */
  private ImageIcon ucIcon;

  /**
   * {@inheritDoc}
   * @see csbase.logic.ProjectFileType#createProjectFileType(csbase.logic.ProjectFileTypeInfo)
   */
  @Override
  protected ProjectFileType createProjectFileType(
    ProjectFileTypeInfo info) {
    return new ClientProjectFileType(info);
  }

  /**
   * Obtm o tipo de arquivo que possui um determinado cdigo.
   * 
   * @param typeCode identificador do arquivo
   * @return o tipo de arquivo que possui um determinado cdigo
   */
  public static ClientProjectFileType getFileType(String typeCode) {
    projectFileTypePrototype = new ClientProjectFileType();
    return (ClientProjectFileType) ProjectFileType.getFileType(typeCode);
  }

  /**
   * Chama o mtodo remoto que carrega os tipos de arquivos a partir do
   * locale
   * 
   * @param locale configurao de idioma
   * @throws RemoteException erro na chamada remota 
   */
  public static void loadFileTypes(Locale locale) throws RemoteException {
    projectFileTypePrototype = new ClientProjectFileType();
    ProjectFileType.loadFileTypes(locale);
  }

  /**
   * Cria um ClientProjectFileType
   *
   * @param info .
   */
  public ClientProjectFileType(ProjectFileTypeInfo info) {
    super(info);
    this.baseIcon = new ImageIcon(info.getBaseIcon());
    this.ucIcon = new ImageIcon(info.getUnderConstructionIcon());
    this.cutIcon = new ImageIcon(info.getCutIcon());
  }

/**
 * Cria um prottipo do objeto ProjectFileType, para que o mtodo
 * createProjectFileType possa ser chamado de forma apropriada.
 */
  protected ClientProjectFileType() {
  }

  /**
   * Obtm o cone que representa um arquivo desse tipo no estado regular.
   *
   * @return .
   */
  public ImageIcon getBaseIcon() {
    return this.baseIcon;
  }

  /**
   * Obtm o cone que representa um arquivo desse tipo, no estado recortado.
   *
   * @return .
   */
  public ImageIcon getCutIcon() {
    return this.cutIcon;
  }

  /**
   * Obtm o cone que representa um arquivo desse tipo no estado em
   * construo.
   *
   * @return .
   */
  public ImageIcon getUnderConstructionIcon() {
    return this.ucIcon;
  }
}
