/*
 * $Id$
 */

package csbase.client.project.action;

import java.awt.Window;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.project.ProjectFileContainer;
import csbase.client.util.SingletonFileChooser;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;

/**
 * Ao sobre projetos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public abstract class CommonProjectAction extends AbstractAction {

  /**
   * Ttulo para janelas de espera.
   */
  protected static final String WAIT_DIALOG_TITLE = LNG
    .get("GENERIC.title.wait");
  /**
   * Ttulo para janelas de erro.
   */
  protected static final String ERROR_DIALOG_TITLE = LNG
    .get("GENERIC.title.error");
  /**
   * O container.
   */
  private ProjectFileContainer container;

  /**
   * Conulta o arquivo selecionado.
   * 
   * @return o arquivo
   */
  protected ClientProjectFile getSelectedFile() {
    return container.getSelectedFile();
  }

  /**
   * Obtm um array com os arquivos selecionados.
   * 
   * @return os arquivos
   */
  protected ClientProjectFile[] getSelectedFiles() {
    return container.getSelectedFiles();
  }

  /**
   * Consulta o nmero de arquivos selecionados.
   * 
   * @return o nmero
   */
  protected int getSelectionCount() {
    return container.getSelectionCount();
  }

  /**
   * Consulta a window do container.
   * 
   * @return a window
   */
  protected Window getWindow() {
    return container.getWindow();
  }

  /**
   * Consulta o ttulo do container.
   * 
   * @return o ttulo
   */
  protected String getTitle() {
    return container.getTitle();
  }

  /**
   * Consulta o projeto corrente.
   * 
   * @return o projeto
   */
  protected CommonClientProject getProject() {
    return container.getProject();
  }

  /**
   * Reseta a seleo do container
   */
  protected void clearSelection() {
    container.clearSelection();
  }

  /**
   * ativa a limpeza do clipboard.
   */
  protected void clearClipboard() {
    container.clearClipboard();
  }

  /**
   * Inicia a ao de rename.
   */
  protected void startRenamingAction() {
    container.startRenamingAction();
  }

  /**
   * Inicia a ao de cut..
   */
  protected void startCutAction() {
    container.startCutAction();
  }

  /**
   * Inicia a ao de copy.
   */
  protected void startCopyAction() {
    container.startCopyAction();
  }

  /**
   * Inicia a ao de paste
   */
  protected void startPasteAction() {
    container.startPasteAction();
  }

  /**
   * Retorna uma instncia nica (singleton) de um dilogo de seleo de
   * arquivos locais.
   * 
   * @return dilogo de seleo de arquivos locais.
   */
  protected JFileChooser getFileChooser() {
    return SingletonFileChooser.getInstance();
  }

  /**
   * Construtor
   * 
   * @param container o container
   */
  public CommonProjectAction(ProjectFileContainer container) {
    this.container = container;
    putValue(Action.NAME, getName());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void actionPerformed(ActionEvent e);

  /**
   * Consulta o nome da ao.
   * 
   * @return o nome
   */
  public abstract String getName();

  /**
   * Exibe uma mensagem de erro usando um ttulo genrico.
   * 
   * @param msg mensagem de erro
   * 
   * @see #showError(Window, String, String)
   */
  protected void showError(String msg) {
    showError(ERROR_DIALOG_TITLE, msg);
  }

  /**
   * Exibe uma mensagem de erro.
   * 
   * @param title ttulo do dilogo
   * @param msg mensagem de erro
   * 
   * @see #showError(Window, String, String)
   */
  protected void showError(String title, String msg) {
    showError(getWindow(), title, msg);
  }

  /**
   * Exibe uma mensagem de erro com ttulo padro.
   * 
   * @param parent janela-me
   * @param msg mensagem de erro
   * 
   * @see #showError(Window, String, String)
   */
  protected void showError(Window parent, String msg) {
    showError(parent, ERROR_DIALOG_TITLE, msg);
  }

  /**
   * Exibe uma mensagem de erro usando o dilogo padro.
   * 
   * @param parent janela-me
   * @param title ttulo do dilogo
   * @param msg mensagem de erro
   */
  protected void showError(Window parent, String title, String msg) {
    StandardDialogs.showErrorDialog(parent, title, msg);
  }
}
