/*
 * $Id$
 */
package csbase.client.util.gui.log.actions;

import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectFileChooserOpen;
import csbase.client.project.ProjectTreePath;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.actions.core.AbstractLogAction;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;

/**
 * Pede para a aplicao que detm o painel de controle por um novo arquivo de
 * log e o abre no painel de log.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class OpenLogAction extends AbstractLogAction {

  /**
   * Tipo de arquivo: texto
   */
  private static final String TEXT = "TEXT";

  /**
   * Tipo de arquivo: log.
   */
  private static final String LOG = "LOG";

  /**
   * Construtor
   * 
   * @param logPanel o painel de log associado a ao.
   */
  public OpenLogAction(final LogPanel logPanel) {
    super(logPanel, ApplicationImages.ICON_OPEN_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) throws Exception {

    DesktopFrame desktop = DesktopFrame.getInstance();
    final CommonClientProject project = desktop.getProject();

    final String[] fileTypes = { LOG, TEXT };
    final String defaultType = fileTypes[0];
    ProjectFileChooserOpen selection = new ProjectFileChooserOpen(getLogPanel()
      .getOwner(), project, false, fileTypes, defaultType);

    final ProjectTreePath treePath = selection.getSelectedPath();
    if (null != treePath) {
      final ClientProjectFile file = treePath.getFile();
      if (file != null) {
        getLogPanel().openFile(file);
      }
    }
  }
}
