package csbase.client.util.xmlpanel.xmltagtreepanel;

import java.awt.BorderLayout;

import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import csbase.client.util.xmlpanel.XMLAbstractPanel;
import csbase.client.util.xmlpanel.XMLPanelNodeSelectionListener;
import csbase.client.util.xmlpanel.XMLPanelStyleInterface;

/**
 * Painel de visualizao de XML em tags com rvore.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class XMLTagTreePanel extends XMLAbstractPanel {

  /**
   * rvore interna do painel.
   */
  final private JTree jtree = new JTree();

  /**
   * Adio de listener
   * 
   * @param nsl listener
   */
  public void addSelectionListener(final XMLPanelNodeSelectionListener nsl) {
    jtree.addTreeSelectionListener(new TreeSelectionListener() {
      @Override
      public void valueChanged(TreeSelectionEvent e) {
        nsl.nodeSelected(getSelectedNode());
      }
    });
  }

  /**
   * Consulta n selecionado.
   * 
   * @return n
   */
  public Node getSelectedNode() {
    final Object object = jtree.getLastSelectedPathComponent();
    return (Node) object;
  }

  /**
   * Ajuste de n da rvore.
   * 
   * @param node n
   */
  @Override
  public void setNode(Node node) {
    internalSetNode(node);
    final XMLTagTreeModel model = new XMLTagTreeModel(node);
    jtree.setModel(model);
    if (node != null) {
      final TreePath pth = getTreePath(node);
      if (pth != null) {
        jtree.expandPath(pth);
      }
    }
  }

  /**
   * Ajuste n selecionado.
   * 
   * @param node n
   */
  public void setSelectedNode(Node node) {
    if (node == null) {
      return;
    }

    TreePath pth;
    Node expNode = node;
    while (expNode != null) {
      pth = getTreePath(expNode);
      if (pth != null) {
        jtree.expandPath(pth);
      }
      expNode = expNode.getParentNode();
    }
    pth = getTreePath(node);
    jtree.setSelectionPath(pth);
    jtree.scrollPathToVisible(pth);
  }

  /**
   * Consulta um path associado a um objeto
   * 
   * @param path path do pai
   * @param node n
   * @return o path
   */
  private TreePath getTreePath(TreePath path, Node node) {
    final Node pathNode = (Node) path.getLastPathComponent();
    if (pathNode == node) {
      return path;
    }

    final NodeList childNodes = pathNode.getChildNodes();
    final int numChildren = childNodes.getLength();
    for (int i = 0; i < numChildren; i++) {
      final Node n = childNodes.item(i);
      final TreePath pth = path.pathByAddingChild(n);
      final TreePath tpath = getTreePath(pth, node);
      if (tpath != null) {
        return tpath;
      }
    }
    return null;
  }

  /**
   * Consulta um path associado a um objeto
   * 
   * @param node n-objeto.
   * @return o path (se existir)
   */
  private TreePath getTreePath(final Node node) {
    final TreeModel model = jtree.getModel();
    final Node root = (Node) model.getRoot();
    final TreePath rootPath = new TreePath(root);
    final TreePath tpath = getTreePath(rootPath, node);
    return tpath;
  }

  /**
   * Busca o definidor de imagens.
   * 
   * @return imager
   */
  public XMLPanelStyleInterface getStyle() {
    XMLTagTreeRenderer rnd = (XMLTagTreeRenderer) jtree.getCellRenderer();
    return rnd.getStyle();
  }

  /**
   * Ajusta o definidor de estilo.
   * 
   * @param style definidor
   */
  public void setStyle(XMLPanelStyleInterface style) {
    XMLTagTreeRenderer rnd = (XMLTagTreeRenderer) jtree.getCellRenderer();
    rnd.setStyle(style);
  }

  /**
   * Construtor
   */
  public XMLTagTreePanel() {
    jtree.setModel(new XMLTagTreeModel(null));
    jtree.setCellRenderer(new XMLTagTreeRenderer());
    jtree.setShowsRootHandles(true);
    final TreeSelectionModel selectionModel = jtree.getSelectionModel();
    selectionModel.setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);

    setLayout(new BorderLayout());
    final JScrollPane scrollPane = new JScrollPane(jtree);
    add(scrollPane, BorderLayout.CENTER);
  }
}
