/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager;

import csbase.client.applicationmanager.ApplicationGroupInternalFrame;
import csbase.client.applicationmanager.ApplicationLink;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationManagerMenuUtilities;
import csbase.client.applications.ApplicationImages;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.util.CSBaseUI;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationCategory;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import tecgraf.javautils.core.lng.LNG;

public class ApplicationPanel
extends JDesktopPane {
    private final Hashtable<String, ApplicationGroupInternalFrame> groupFrames = new Hashtable();
    private static final String APPS_INFO = "APPS_INFO";

    public void setProjectFlag(boolean hasProject) {
        ApplicationManager appManager = ApplicationManager.getInstance();
        if (appManager == null) {
            return;
        }
        appManager.setProjectFlag(hasProject);
    }

    public AbstractAction getApplicationAction(String aid) {
        ApplicationManager appManager = ApplicationManager.getInstance();
        if (appManager == null) {
            return null;
        }
        ApplicationRegistry reg = appManager.getApplicationRegistry(aid);
        if (reg == null) {
            return null;
        }
        return appManager.getApplicationAction(reg);
    }

    private List<ApplicationGroupInternalFrame> getAllInternalFrames() {
        JInternalFrame[] frames;
        ArrayList<ApplicationGroupInternalFrame> list = new ArrayList<ApplicationGroupInternalFrame>();
        for (JInternalFrame frm : frames = this.getAllFrames()) {
            list.add((ApplicationGroupInternalFrame)frm);
        }
        Collections.sort(list, new Comparator<JInternalFrame>(){

            @Override
            public int compare(JInternalFrame o1, JInternalFrame o2) {
                String n1 = o1.getTitle();
                String n2 = o2.getTitle();
                return n1.compareToIgnoreCase(n2);
            }
        });
        return list;
    }

    public void tileGroupsHorizontal() {
        List<ApplicationGroupInternalFrame> frames = this.getAllInternalFrames();
        int nframes = frames.size();
        if (nframes == 0) {
            return;
        }
        int height = this.getHeight();
        int width = this.getWidth() / nframes;
        int i = 0;
        for (ApplicationGroupInternalFrame frame : frames) {
            try {
                frame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (frame.isMaximum()) {
                try {
                    frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            frame.setSize(width, height);
            frame.setLocation(i * width, 0);
            frame.adjustIcons();
            ++i;
        }
    }

    public void tileGroupsVertical() {
        List<ApplicationGroupInternalFrame> frames = this.getAllInternalFrames();
        int nframes = frames.size();
        int height = this.getHeight() / nframes;
        int width = this.getWidth();
        int i = 0;
        for (ApplicationGroupInternalFrame frame : frames) {
            try {
                frame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (frame.isMaximum()) {
                try {
                    frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            frame.setSize(width, height);
            frame.setLocation(0, i * height);
            frame.adjustIcons();
            ++i;
        }
    }

    public void iconifyGroups(boolean flag) {
        List<ApplicationGroupInternalFrame> frames = this.getAllInternalFrames();
        for (ApplicationGroupInternalFrame frame : frames) {
            try {
                frame.setIcon(flag);
            }
            catch (Exception exception) {}
        }
    }

    public final JPopupMenu createGroupsConfigurationPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        this.fillMenuItens(menu);
        return menu;
    }

    public final JMenu createGroupsConfigurationMenu() {
        JMenu menu = new JMenu(LNG.get((String)"desktop.config.groups"));
        this.fillMenuItens(menu);
        return menu;
    }

    private void fillMenuItens(JComponent cmp) {
        if (!(cmp instanceof JPopupMenu) && !(cmp instanceof JMenu)) {
            throw new IllegalArgumentException("bad element set");
        }
        JMenuItem iconItem = new JMenuItem(LNG.get((String)"desktop.groups.iconify"));
        iconItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ApplicationPanel.this.iconifyGroups(true);
            }
        });
        JMenuItem deiconItem = new JMenuItem(LNG.get((String)"desktop.groups.deiconify"));
        deiconItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ApplicationPanel.this.iconifyGroups(false);
            }
        });
        JMenuItem cascItem = new JMenuItem(LNG.get((String)"desktop.groups.cascade"));
        cascItem.setIcon(ApplicationImages.ICON_WINCASCADE_16);
        cascItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ApplicationPanel.this.cascadeGroups();
            }
        });
        JMenuItem tileVertItem = new JMenuItem(LNG.get((String)"desktop.groups.tile_vertical"));
        tileVertItem.setIcon(ApplicationImages.ICON_WINTILEVERTICAL_16);
        tileVertItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ApplicationPanel.this.tileGroupsVertical();
            }
        });
        JMenuItem tileHorItem = new JMenuItem(LNG.get((String)"desktop.groups.tile_horizontal"));
        tileHorItem.setIcon(ApplicationImages.ICON_WINTILEHORIZONTAL_16);
        tileHorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ApplicationPanel.this.tileGroupsHorizontal();
            }
        });
        cmp.add(iconItem);
        cmp.add(deiconItem);
        cmp.add(cascItem);
        cmp.add(tileVertItem);
        cmp.add(tileHorItem);
    }

    public final void addProjectTreeListernerForLayoutAutoPersistency(ProjectTree projectTree) {
        projectTree.addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject project) {
                if (project != null) {
                    User loggedUser = User.getLoggedUser();
                    ApplicationPanel.this.setGroupsFrameInfo(project.getGroupsFrameConfig(loggedUser.getId()));
                }
            }

            @Override
            public void projectClosed(CommonClientProject project) {
                if (project != null) {
                    User loggedUser = User.getLoggedUser();
                    project.setGroupsFrameInfo(loggedUser.getId(), ApplicationPanel.this.getGroupsFrameInfo());
                }
            }
        });
    }

    public final void addMouseListenerForLayoutMenu() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu menu;
                int x = e.getX();
                int y = e.getY();
                int button = e.getButton();
                if (button == 1 && (menu = ApplicationPanel.this.createGroupsConfigurationPopupMenu()) != null) {
                    menu.show(ApplicationPanel.this, x, y);
                }
            }
        });
    }

    public final void addMouseListenerForApplicationsMenu() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu menu;
                int x = e.getX();
                int y = e.getY();
                int button = e.getButton();
                if (button == 3 && (menu = ApplicationManagerMenuUtilities.buildPopupMenu()) != null) {
                    menu.show(ApplicationPanel.this, x, y);
                }
            }
        });
    }

    public void cascadeGroups() {
        List<ApplicationGroupInternalFrame> frames = this.getAllInternalFrames();
        int dx = 70;
        int dy = 50;
        int offsetX = 10;
        int offsetY = 20;
        int height = (int)((double)this.getHeight() * 0.6);
        int width = (int)((double)height * 1.6);
        int i = 0;
        for (ApplicationGroupInternalFrame frame : frames) {
            try {
                frame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (frame.isMaximum()) {
                try {
                    frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            frame.setSize(width, height);
            frame.setLocation(offsetX + i * dx, offsetY + i * dy);
            frame.adjustIcons();
            frame.toFront();
            ++i;
        }
    }

    private void mountFrames() {
        ApplicationManager mng = ApplicationManager.getInstance();
        Hashtable<String, ApplicationCategory> cts = mng.getAllApplicationCategories();
        if (cts == null) {
            return;
        }
        Collection<ApplicationCategory> categories = cts.values();
        for (ApplicationCategory cat : categories) {
            if (!cat.isShownAtApplicationPanel()) continue;
            String name = mng.getCategoryName(cat);
            ImageIcon icon = cat.getIcon() == null ? null : new ImageIcon(cat.getIcon());
            ApplicationGroupInternalFrame groupFrame = new ApplicationGroupInternalFrame(name, icon, this.getApplicationLinks(cat));
            this.add(groupFrame);
            this.groupFrames.put(cat.getId(), groupFrame);
        }
    }

    private List<ApplicationLink> getApplicationLinks(ApplicationCategory cat) {
        ArrayList<ApplicationLink> links = new ArrayList<ApplicationLink>();
        ArrayList ids = cat.getApplicationIds();
        for (String id : ids) {
            ApplicationLink link;
            ApplicationManager mng = ApplicationManager.getInstance();
            ApplicationRegistry reg = mng.getApplicationRegistry(id);
            if (reg == null || !reg.isShownAtApplicationPanel() || (link = mng.getApplicationLink(reg)) == null) continue;
            links.add(link);
        }
        return links;
    }

    private void setGroupsFrameInfo(Hashtable grpsInfo) {
        if (grpsInfo == null) {
            return;
        }
        ApplicationManager appManager = ApplicationManager.getInstance();
        Hashtable<String, ApplicationCategory> hash = appManager.getAllApplicationCategories();
        Collection<ApplicationCategory> cats = hash.values();
        for (ApplicationCategory cat : cats) {
            ApplicationGroupInternalFrame grpFrame = this.groupFrames.get(cat.getId());
            if (grpFrame == null) continue;
            grpFrame.getPanel().setLayout(null);
            Hashtable grpInfo = (Hashtable)grpsInfo.get(cat);
            if (grpInfo == null) continue;
            grpFrame.setInfo(grpInfo);
            Hashtable appsInfo = (Hashtable)grpInfo.get(APPS_INFO);
            if (appsInfo == null) continue;
            ArrayList grpApps = cat.getApplicationIds();
            for (String grpApp : grpApps) {
                ApplicationRegistry reg;
                ApplicationLink al;
                Hashtable appInfo = (Hashtable)appsInfo.get(grpApp);
                if (appInfo == null || (al = appManager.getApplicationLink(reg = appManager.getApplicationRegistry(grpApp))) == null) continue;
                al.setInfo(appInfo);
            }
        }
    }

    private Hashtable getGroupsFrameInfo() {
        ApplicationManager appManager = ApplicationManager.getInstance();
        Hashtable<String, ApplicationCategory> hash = appManager.getAllApplicationCategories();
        Collection<ApplicationCategory> cats = hash.values();
        Hashtable<String, Hashtable<String, Object>> grpsInfo = new Hashtable<String, Hashtable<String, Object>>();
        for (ApplicationCategory cat : cats) {
            ApplicationGroupInternalFrame grpFrame = this.groupFrames.get(cat.getId());
            if (grpFrame == null) continue;
            Hashtable<String, Object> grpInfo = grpFrame.getInfo();
            ArrayList grpApps = cat.getApplicationIds();
            Hashtable<String, Hashtable<String, Integer>> appsInfo = new Hashtable<String, Hashtable<String, Integer>>();
            for (String grpApp : grpApps) {
                ApplicationLink al;
                ApplicationRegistry reg = appManager.getApplicationRegistry(grpApp);
                if (reg == null || (al = appManager.getApplicationLink(reg)) == null) continue;
                appsInfo.put(grpApp, al.getInfo());
            }
            grpInfo.put(APPS_INFO, appsInfo);
            grpsInfo.put(cat.getId(), grpInfo);
        }
        return grpsInfo;
    }

    public ApplicationPanel() {
        this.setBackground(CSBaseUI.DESKTOP_BACKGROUND_COLOR);
        this.setProjectFlag(false);
        this.mountFrames();
        this.cascadeGroups();
    }
}

