/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import java.awt.Window;
import java.io.File;
import java.text.Collator;
import java.util.Collections;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class AbstractVersionTreeNode
extends DefaultMutableTreeNode
implements Comparable<MutableTreeNode> {
    private static final JPopupMenu NULL_POPUP_MENU = new JPopupMenu(){

        @Override
        public void show() {
        }
    };
    private VersionTree tree;

    public AbstractVersionTreeNode(VersionTree tree, Object userObject) {
        super(userObject);
        this.tree = tree;
    }

    public final VersionTree getTree() {
        return this.tree;
    }

    public final Window getWindow() {
        return this.tree.getOwner();
    }

    public JPopupMenu createPopupMenu() {
        return NULL_POPUP_MENU;
    }

    public boolean allowMultipleSelection(AbstractVersionTreeNode other) {
        return true;
    }

    @Override
    public void add(MutableTreeNode newChild) {
        int index;
        if (newChild != null && newChild.getParent() == this) {
            this.remove(newChild);
        }
        if ((index = this.children == null ? 0 : Collections.binarySearch(this.children, newChild)) < 0) {
            index = -index - 1;
        }
        this.insert(newChild, index);
    }

    public String getName() {
        TreeNode[] path;
        StringBuilder name = new StringBuilder();
        for (TreeNode node : path = this.getPath()) {
            name.append(File.separator).append(node.toString());
        }
        return name.toString();
    }

    @Override
    public int compareTo(MutableTreeNode node) {
        return Collator.getInstance().compare(this.toString(), node.toString());
    }

    public abstract ImageIcon getImageIcon();
}

