/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.multiflow.tree;

import csbase.client.applications.flowapplication.multiflow.tree.AlgorithmNode;
import csbase.client.applications.flowapplication.multiflow.tree.ParameterNode;
import csbase.client.applications.flowapplication.multiflow.tree.ParameterSelection;
import csbase.client.applications.flowapplication.multiflow.tree.ParameterSelectionModel;
import csbase.client.applications.flowapplication.multiflow.tree.RootNode;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.NodeParameter;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ParameterSelectionCellRenderer
extends JCheckBox
implements TreeCellRenderer {
    private ParameterSelectionModel selectionModel;

    public ParameterSelectionCellRenderer(ParameterSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
        this.setOpaque(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (node instanceof RootNode) {
            RootNode root = (RootNode)node;
            Flow flow = root.getUserObject();
            this.setText(flow.getName());
            this.setToolTipText(flow.getDescription());
        } else if (node instanceof AlgorithmNode) {
            AlgorithmNode algorithmNode = (AlgorithmNode)node;
            FlowNode flowNode = algorithmNode.getUserObject();
            this.setText(flowNode.getAlgorithmName());
            this.setToolTipText(node.toString());
        } else if (node instanceof ParameterNode) {
            ParameterNode parameterNode = (ParameterNode)node;
            ParameterSelection selection = parameterNode.getUserObject();
            NodeParameter parameter = selection.parameter;
            this.setText(parameter.getLabel());
            this.setToolTipText(parameter.toString());
        }
        TreePath path = tree.getPathForRow(row);
        if (path != null) {
            if (this.selectionModel.isPathSelected(path, true)) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
        }
        return this;
    }
}

