/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import csbase.logic.AlgorithmsReloadNotification;
import csbase.logic.CloseProjectNotification;
import csbase.logic.CommandEndNotification;
import csbase.logic.CommandErrorNotification;
import csbase.logic.CommandFailedNotification;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandKilledNotification;
import csbase.logic.CommandLostNotification;
import csbase.logic.CommandSuccessNotification;
import csbase.logic.CommandWithNoExitCodeNotification;
import csbase.logic.FileSystemSpaceNotification;
import csbase.logic.FileUpdateNotification;
import csbase.logic.Notification;
import csbase.logic.OpenProjectNotification;
import csbase.logic.ProjectAdminInfo;
import csbase.logic.ProjectAllocationState;
import csbase.logic.ProjectNotification;
import csbase.logic.ProjectRecoveryFailureNotification;
import csbase.logic.ProjectRecoverySuccessNotification;
import csbase.logic.SGANotification;
import csbase.logic.SGASet;
import csbase.logic.ServerNotification;
import csbase.logic.UserNotification;
import csbase.logic.UsersNotification;
import csbase.logic.applicationservice.ApplicationsReloadNotification;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;

public class NotificationTranslator {
    private static final String LNG_PREFIX = "NotificationTranslator.";

    public String translate(Object data) {
        return LNG.get((String)"notification.object.internal.error");
    }

    public String translate(Notification data) {
        return LNG.get((String)"notification.untyped.object.internal.error");
    }

    public String translate(UserNotification data) {
        return data.toString();
    }

    public String translate(AlgorithmsReloadNotification data) {
        return LNG.get((String)"notification.data.algorithms.reload");
    }

    public String translate(ApplicationsReloadNotification data) {
        return LNG.get((String)"notification.data.applications.reload");
    }

    public String translate(SGANotification data) {
        SGASet info = data.getMainInfo();
        String sgaFormat = null;
        String sgaName = info.getName() + "/" + info.getPlatformId();
        if (data.getFlag() == 0) {
            sgaFormat = LNG.get((String)"notification.data.sga.startup");
        } else if (data.getFlag() == 1) {
            sgaFormat = LNG.get((String)"notification.data.sga.shutdown");
        } else if (data.getFlag() == 2) {
            sgaFormat = LNG.get((String)"notification.data.sga.reinit");
        } else if (data.getFlag() == 3) {
            sgaFormat = LNG.get((String)"notification.data.sga.update");
        } else {
            return "!!!";
        }
        return MessageFormat.format(sgaFormat, sgaName);
    }

    public String translate(ServerNotification data) {
        if (data.getState()) {
            String startStr = LNG.get((String)"notification.data.server.startup");
            return startStr;
        }
        String shutdownStr = LNG.get((String)"notification.data.server.shutdown");
        return shutdownStr;
    }

    public String translate(CommandEndNotification data) {
        if (data.hasTimeInfo()) {
            return MessageFormat.format(LNG.get((String)"notification.data.command.end"), data.getCommandId(), data.getCmdDesc(), data.getTip(), this.formatInterval(data.getUserTime()), this.formatInterval(data.getCPUTime()), this.formatInterval(data.getElapsedTime()), data.getStartTime(), data.getEndTime(), data.getExecHost());
        }
        return MessageFormat.format(LNG.get((String)"notification.data.command.end.no.data"), data.getCommandId(), data.getCmdDesc(), data.getTip(), data.getStartTime(), data.getEndTime(), data.getExecHost());
    }

    public String translate(CommandErrorNotification data) {
        return MessageFormat.format(LNG.get((String)"notification.data.command.error"), data.getCommandId(), data.getCmdDesc(), data.getTip(), data.getStartTime(), data.getExecHost(), data.getFinalizationInfo().getExitCode());
    }

    public String translate(CommandWithNoExitCodeNotification data) {
        return MessageFormat.format(LNG.get((String)"notification.data.command.no_code"), data.getCommandId(), data.getCmdDesc(), data.getTip(), data.getStartTime(), data.getExecHost());
    }

    public String translate(CommandSuccessNotification data) {
        Object[] arguments = new Object[]{data.getCommandId(), data.getCmdDesc(), data.getTip(), this.formatInterval(data.getUserTime()), this.formatInterval(data.getCPUTime()), this.formatInterval(data.getElapsedTime()), data.getStartTime(), data.getEndTime(), data.getExecHost()};
        if (data.hasWarnings()) {
            return MessageFormat.format(LNG.get((String)"notification.data.command.warning"), arguments);
        }
        return MessageFormat.format(LNG.get((String)"notification.data.command.success"), arguments);
    }

    private String formatInterval(Integer timesec) {
        if (timesec == null || timesec < 0) {
            return "---";
        }
        return FormatUtils.formatInterval((int)timesec);
    }

    public String translate(CommandLostNotification data) {
        return MessageFormat.format(LNG.get((String)"notification.data.command.lost"), data.getCommandId(), data.getCmdDesc(), data.getTip(), data.getStartTime(), data.getExecHost());
    }

    public String translate(CommandFailedNotification data) {
        CommandFinalizationInfo info = data.getFinalizationInfo();
        return MessageFormat.format(LNG.get((String)"notification.data.command.failed"), data.getCommandId(), data.getCmdDesc(), data.getTip(), data.getStartTime(), data.getExecHost(), info.getFailureCause() == null ? info.getFinalizationType().getDescription() : info.getFailureCause().getDescription());
    }

    public String translate(CommandKilledNotification data) {
        CommandFinalizationInfo info = data.getFinalizationInfo();
        return MessageFormat.format(LNG.get((String)"notification.data.command.killed"), data.getCommandId(), data.getCmdDesc(), data.getTip(), data.getStartTime(), data.getExecHost(), info.getFailureCause() == null ? info.getFinalizationType().getDescription() : info.getFailureCause().getDescription());
    }

    public String translate(UsersNotification data) {
        String text = null;
        Object projectAdmin = data.getUserId();
        String projectName = data.getProjectName();
        if (data.getType() == 0) {
            text = LNG.get((String)"notification.data.project.manager.user.inserted");
        } else if (data.getType() == 1) {
            text = LNG.get((String)"notification.data.project.manager.user.removed");
        } else if (data.getType() == 2) {
            text = LNG.get((String)"notification.data.project.manager.user.changed");
        } else if (data.getType() == 3) {
            text = LNG.get((String)"notification.data.project.manager.prj.deleted");
        } else {
            return LNG.get((String)"notification.data.project.manager.unknown");
        }
        return MessageFormat.format(text, projectName, projectAdmin);
    }

    public String translate(ProjectNotification data) {
        ProjectAdminInfo info = data.getProjectAdminInfo();
        ProjectAllocationState state = info.getState();
        if (state == ProjectAllocationState.WAITING_AREA_ALLOCATION) {
            return MessageFormat.format(LNG.get((String)"notification.data.area.alloc.wait"), info.getProjectName(), info.getOwnerId());
        }
        if (state == ProjectAllocationState.UNLOCKED_WITH_AREA_ALLOCATED) {
            return MessageFormat.format(LNG.get((String)"notification.data.area.unlock"), info.getProjectName(), new Long(info.getAreaRequestSize()), new Long(info.getAreaLockedSize()));
        }
        if (state == ProjectAllocationState.WAITING_AREA_FREE) {
            return MessageFormat.format(LNG.get((String)"notification.data.area.free.wait"), info.getProjectName(), info.getOwnerId());
        }
        return LNG.get((String)"notification.data.area.no.msg.error");
    }

    public String translate(ProjectRecoveryFailureNotification data) {
        String ownerLogin = data.getOwnerLogin();
        String ownerName = data.getOwnerName();
        String projectName = data.getProjectName();
        Object[] args = new Object[]{ownerLogin, ownerName, projectName};
        String fmt = LNG.get((String)"notification.project.recovery.failure");
        String text = String.format(fmt, args);
        return text;
    }

    public String translate(ProjectRecoverySuccessNotification data) {
        String ownerLogin = data.getOwnerLogin();
        String ownerName = data.getOwnerName();
        String projectName = data.getProjectName();
        Object[] args = new Object[]{ownerLogin, ownerName, projectName};
        String fmt = LNG.get((String)"notification.project.recovery.success");
        String text = String.format(fmt, args);
        return text;
    }

    public String translate(OpenProjectNotification data) {
        Object[] args = new Object[]{data.getProjectName()};
        String fmt = LNG.get((String)"notification.data.project.open");
        return MessageFormat.format(fmt, args);
    }

    public String translate(FileSystemSpaceNotification data) {
        String fsId = data.getFileSystemId();
        String key = "notification.data.file.system." + fsId;
        String fsText = !LNG.hasKey((String)key) ? fsId : LNG.get((String)key);
        String msg = LNG.get((String)"notification.data.file.system.space");
        int scale = data.getScale();
        double perc = data.getPercentage();
        String text = String.format(msg, fsText, perc, scale);
        return text;
    }

    public String translate(CloseProjectNotification data) {
        return MessageFormat.format(LNG.get((String)"notification.data.project.close"), data.getProjectName());
    }

    public String translate(FileUpdateNotification data) {
        switch (data.getResult()) {
            case SUCCESS: {
                return MessageFormat.format(LNG.get((String)"NotificationTranslator.file.update.success"), data.getFilePath());
            }
            case SOURCE_NOT_FOUND: {
                return MessageFormat.format(LNG.get((String)"NotificationTranslator.file.update.source.not.found"), data.getFilePath());
            }
            case NO_PERMISSION: {
                return MessageFormat.format(LNG.get((String)"NotificationTranslator.file.update.no.permission"), data.getFilePath());
            }
            case UNEXPECTED_ERROR: {
                return MessageFormat.format(LNG.get((String)"NotificationTranslator.file.update.unexpected.error"), data.getFilePath());
            }
            case TEMPORARILY_UNAVAILABLE: {
                return MessageFormat.format(LNG.get((String)"NotificationTranslator.file.update.temporarily_unavailable"), data.getFilePath());
            }
            case DISABLED: {
                return MessageFormat.format(LNG.get((String)"NotificationTranslator.file.update.disabled"), data.getFilePath());
            }
        }
        return "Resultado desconhecido." + data.toString();
    }
}

