/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.xmlpanel;

import csbase.logic.ClientFile;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XMLPanelUtils {
    public static List<Node> getAttributeChildren(Node parentNode) {
        ArrayList<Node> children = new ArrayList<Node>();
        if (parentNode == null) {
            return children;
        }
        NamedNodeMap attributes = parentNode.getAttributes();
        if (attributes == null) {
            return children;
        }
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Node item = attributes.item(i);
            children.add(item);
        }
        return children;
    }

    public static String getFirstChildAttributeValue(Node parentNode, String childName, String attrName) {
        Node firstChild = XMLPanelUtils.getFirstChild(parentNode, childName);
        if (firstChild == null) {
            return null;
        }
        return XMLPanelUtils.getAttributeValue(firstChild, attrName);
    }

    public static String getAttributeValue(Node node, String attrName) {
        if (node == null) {
            return null;
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Node item = attributes.item(i);
            if (!item.getNodeName().equals(attrName)) continue;
            return item.getNodeValue();
        }
        return null;
    }

    public static boolean hasAttributeValue(Node node, String attrName, String valueText) {
        String attributeValue = XMLPanelUtils.getAttributeValue(node, attrName);
        if (attributeValue == null) {
            return false;
        }
        return attributeValue.equals(valueText.trim());
    }

    public static Node getFirstChild(Node parentNode, String childName) {
        List<Node> children = XMLPanelUtils.getElementChildren(parentNode);
        for (Node child : children) {
            if (!child.getNodeName().equals(childName)) continue;
            return child;
        }
        return null;
    }

    public static List<Node> getElementChildren(Node parentNode) {
        ArrayList<Node> children = new ArrayList<Node>();
        if (parentNode == null) {
            return children;
        }
        NodeList childNodes = parentNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (item.getNodeType() != 1) continue;
            children.add(item);
        }
        return children;
    }

    public static Node getRootNode(ClientFile clientFile, EntityResolver resolver, Charset charset) throws Exception {
        if (clientFile == null) {
            return null;
        }
        InputStream inputStream = clientFile.getInputStream();
        Node document = XMLPanelUtils.getRootNode(inputStream, resolver, charset);
        return document;
    }

    public static Node getRootNode(InputStream stream, EntityResolver er, Charset charset) throws Exception {
        InputSource is = new InputSource(stream);
        if (charset != null) {
            is.setEncoding(charset.name());
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (er == null) {
            String addr = "http://apache.org/";
            String dtd = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
            factory.setAttribute(dtd, false);
            dtd = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            factory.setAttribute(dtd, false);
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(er);
        Document document = builder.parse(is);
        Element rootNode = document.getDocumentElement();
        return rootNode;
    }
}

