package csbase.client.applications.flowapplication.actions;

import javax.swing.ImageIcon;

import csbase.client.applications.flowapplication.FlowApplication;
import csbase.logic.MultipleFlowPermission;
import csbase.logic.Permission;
import csbase.logic.User;

/**
 * Classe base para aes relacioanadas  execuo mltipla de fluxos. Aes
 * desse tipo s so habilitadas caso o usurio tenha permisso especfica para
 * execuo de fluxos mltiplos.
 */
public abstract class MultipleExecutionAction extends FlowApplicationAction {

  /**
   * Construtor.
   * 
   * @param application A aplicao construtura de fluxos.
   * @param icon O cone da ao.
   */
  protected MultipleExecutionAction(FlowApplication application, ImageIcon icon) {
    super(application, icon);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setEnabled(boolean enabled) {
    User loggedUser = User.getLoggedUser();
    if (!loggedUser.isAdmin()) {
      Permission permission =
        loggedUser.getPermission(MultipleFlowPermission.class);
      if (permission == null) {
        super.setEnabled(false);
      }
      else {
        super.setEnabled(enabled);
      }
    }
    else {
      super.setEnabled(enabled);
    }
  }

}
