/*
 * $Id$
 */

package csbase.client.facilities.monitoring;

/**
 * A interface <code>DynamicInfoHandler</code> modela um gerenciador genrico de
 * informaes dinmicas. Essas informaes devero ser representadas em um
 * array de objetos, cujos elementos devem pertencer a classes que permitam a
 * obteno do "nome" do elemento correspondente e um valor corrente (double).
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface DynamicInfoHandler {
  /**
   * Atualizao da informaes dinmicas.
   * 
   * @param dynamicInfo info
   */
  public void updateInfo(Object[] dynamicInfo);

  /**
   * Consulta nome do elemento {@code i}.
   * 
   * @param i ndice
   * @return nome
   */
  public String getName(int i);

  /**
   * Consulta valor do elemento {@code i}.
   * 
   * @param i ndice
   * @return valor
   */
  public double getCurrentValue(int i);

  /**
   * Consulta a validadade do elemento {@code i}.
   * 
   * @param i ndice
   * @return indicativo
   */
  public boolean isValid(int i);

  /**
   * Consulta o tamanho total.
   * 
   * @return tamanho
   */
  public int getTotalSize();

  /**
   * Consulta o tamanho vlido.
   * 
   * @return tamanho
   */
  public int getValidSize();
}
