/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.view;

import csbase.client.algorithms.commands.view.CommandViewType;
import csbase.client.algorithms.commands.view.ConsolidatedLogsTab;
import csbase.client.algorithms.commands.view.LogTabConfiguration;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandInfo;
import csbase.logic.CommonClientProject;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.core.lng.LNG;

public class GetLogTabConfigurationsTask
extends RemoteTask<List<LogTabConfiguration>> {
    private static final String LOG_TAB_ID_PROPERTY_NAME = "tab.{0}.id";
    private static final String LOG_TAB_TITLE_PROPERTY_NAME = "tab.{0}.title.{1}";
    private static final String LOG_TAB_FILE_PATTERN_PROPERTY_NAME = "tab.{0}.log.file.pattern.{1}";
    private static final String ID_REPLACEMENT_TAG = "$ID";
    private CommandViewType logViewType;
    private String idForLogPattern;
    protected CommandInfo commandInfo;

    public GetLogTabConfigurationsTask(CommandInfo commandInfo, CommandViewType logViewType, String idForLogPattern) {
        this.commandInfo = commandInfo;
        this.logViewType = logViewType;
        this.idForLogPattern = idForLogPattern;
    }

    public GetLogTabConfigurationsTask(CommandInfo commandInfo, CommandViewType logViewType) {
        this(commandInfo, logViewType, null);
    }

    protected void performTask() throws IOException, ConfigurationManagerException {
        this.setResult(this.getLogTabConfigurations());
    }

    private List<LogTabConfiguration> getLogTabConfigurations() throws ConfigurationManagerException, RemoteException {
        ArrayList<LogTabConfiguration> configurations = new ArrayList<LogTabConfiguration>();
        ConfigurationManager cnfManager = ConfigurationManager.getInstance();
        if (cnfManager != null) {
            Class<ConsolidatedLogsTab> propClass = ConsolidatedLogsTab.class;
            Configuration cnf = cnfManager.getConfiguration(propClass);
            ClientProjectFile logsBaseDir = this.getLogsSearchPath();
            if (logsBaseDir != null) {
                ClientProjectFile[] children = logsBaseDir.getChildren();
                boolean continueReading = true;
                int i = 1;
                while (continueReading) {
                    String tabId = cnf.getOptionalProperty(MessageFormat.format(LOG_TAB_ID_PROPERTY_NAME, i));
                    if (tabId != null) {
                        String title = cnf.getMandatoryProperty(MessageFormat.format(LOG_TAB_TITLE_PROPERTY_NAME, tabId, LNG.getLocale()));
                        List filePatterns = cnf.getMandatoryListProperty(MessageFormat.format(LOG_TAB_FILE_PATTERN_PROPERTY_NAME, tabId, this.logViewType.getPropertyName()));
                        Set<ClientProjectFile> matchingFiles = this.findLogFiles(children, filePatterns);
                        if (!matchingFiles.isEmpty()) {
                            configurations.add(new LogTabConfiguration(tabId, title, matchingFiles));
                        }
                    } else {
                        continueReading = false;
                    }
                    ++i;
                }
            }
        }
        return configurations;
    }

    private ClientProjectFile getLogsSearchPath() throws RemoteException {
        DesktopFrame desktop;
        CommonClientProject project;
        ClientProjectFile logsBaseDir = null;
        String[] logsPath = this.commandInfo.getPersistencyPath();
        if (logsPath != null && (project = (desktop = DesktopFrame.getInstance()).getProject()) != null) {
            logsBaseDir = project.getFile(logsPath);
        }
        return logsBaseDir;
    }

    private Set<ClientProjectFile> findLogFiles(ClientProjectFile[] files, List<String> patterns) throws RemoteException {
        HashSet<ClientProjectFile> logFiles = new HashSet<ClientProjectFile>();
        for (ClientProjectFile file : files) {
            if (file.isDirectory()) {
                logFiles.addAll(this.findLogFiles(file.getChildren(), patterns));
                continue;
            }
            if (!this.matchesPatterns(file, patterns)) continue;
            logFiles.add(file);
        }
        return logFiles;
    }

    private boolean matchesPatterns(ClientProjectFile file, List<String> logFilePatterns) {
        if (logFilePatterns != null) {
            for (String pattern : logFilePatterns) {
                if (this.idForLogPattern != null) {
                    pattern = pattern.replace(ID_REPLACEMENT_TAG, this.idForLogPattern);
                }
                if (!file.getName().matches(pattern.trim())) continue;
                return true;
            }
        }
        return false;
    }
}

