/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.Client;
import csbase.client.algorithms.parameters.ParameterGroupViewListener;
import csbase.client.algorithms.parameters.ParameterLoaderView;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.ParameterViewFactory;
import csbase.client.algorithms.parameters.ParameterViewListener;
import csbase.client.algorithms.parameters.SimpleParameterView;
import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.validation.ViewValidator;
import csbase.client.algorithms.view.simple.SimpleAlgorithmConfiguratorPanel;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.ParameterLoader;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.panel.ExpandablePanel;

public final class ParameterGroupView
extends ParameterView<ParameterGroup> {
    private final List<ParameterGroupViewListener> listeners;
    private JPanel componentsPanel;
    private List<ParameterView<?>> parameterViews;
    private ParameterLoaderView parameterLoaderView;
    private final SimpleAlgorithmConfiguratorPanel configurationPanel;

    public void addParameterGroupViewListener(ParameterGroupViewListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    private void createComponentsPanel() {
        String title = ((ParameterGroup)this.getParameter()).getLabel();
        if (this.getGroup().isCollapsible()) {
            ExpandablePanel expandablePanel = new ExpandablePanel(title, ExpandablePanel.Position.CONTROL_LEFT);
            TitledBorder titledBorder = BorderFactory.createTitledBorder("");
            expandablePanel.setBorder((Border)titledBorder);
            this.componentsPanel = expandablePanel;
        } else {
            this.componentsPanel = new JPanel(new GridBagLayout());
            if (!title.trim().isEmpty()) {
                TitledBorder titledBorder = BorderFactory.createTitledBorder(title);
                titledBorder.setTitleJustification(1);
                this.componentsPanel.setBorder(titledBorder);
            }
        }
        this.populatePanel();
    }

    private void createParameterListeners() {
        for (ParameterView parameterView : this.getParameterViews()) {
            parameterView.addParameterViewListener(new ParameterViewListener(){

                @Override
                public void visibilityWasChanged(ParameterView<?> paramView) {
                    ParameterGroupView.this.updateVisibilyView();
                    ParameterGroupView.this.fireChildParameterVisibilityWasChanged();
                }
            });
        }
    }

    private void createParameterLoaderView() {
        ParameterLoader parameterLoader = this.getGroup().getParameterLoader();
        if (parameterLoader != null && this.getMode().equals((Object)ParameterView.Mode.CONFIGURATION)) {
            this.parameterLoaderView = new ParameterLoaderView(this, parameterLoader);
        }
    }

    private void createParameterViews() {
        this.parameterViews = new LinkedList();
        for (Parameter parameter : this.getGroup().getParameters()) {
            ParameterViewFactory parameterViewFactory = Client.getInstance().getParameterViewFactory();
            ParameterView<?> parameterView = parameterViewFactory.create(this.configurationPanel, parameter, this.getMode());
            if (parameterView == null) continue;
            this.parameterViews.add(parameterView);
        }
    }

    @Override
    public boolean fillVerticalSpace() {
        return this.resizesVertically(this.parameterViews);
    }

    private void fireChildParameterVisibilityWasChanged() {
        for (ParameterGroupViewListener listener : this.listeners) {
            listener.childParameterVisibilityChanged(this);
        }
    }

    public AlgorithmConfigurator getConfigurator() {
        return this.configurationPanel.getConfigurator();
    }

    public ParameterGroup getGroup() {
        return (ParameterGroup)this.getParameter();
    }

    public JPanel getPanel() {
        for (ParameterView parameterView : this.getParameterViews()) {
            if (!parameterView.isVisible()) continue;
            return this.componentsPanel;
        }
        this.componentsPanel.setVisible(false);
        return this.componentsPanel;
    }

    public SimpleParameterView<?> getParameterView(String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterName est\u00e1 nulo.");
        }
        for (SimpleParameterView<?> parameterView : this.getParameterViews()) {
            if (!((SimpleParameter)parameterView.getParameter()).getName().equals(parameterName)) continue;
            return parameterView;
        }
        return null;
    }

    public List<SimpleParameterView<?>> getParameterViews() {
        LinkedList<SimpleParameterView> paramViews = new LinkedList<SimpleParameterView>();
        SimpleParameterView simpleParameterView = null;
        for (ParameterView<?> parameterView : this.parameterViews) {
            if (parameterView instanceof ParameterGroupView) {
                ParameterGroupView groupView = (ParameterGroupView)parameterView;
                paramViews.addAll(groupView.getParameterViews());
                continue;
            }
            if (!(parameterView instanceof SimpleParameterView)) continue;
            simpleParameterView = (SimpleParameterView)parameterView;
            paramViews.add(simpleParameterView);
        }
        return Collections.unmodifiableList(paramViews);
    }

    public Window getWindow() {
        return this.configurationPanel.getWindow();
    }

    @Override
    protected boolean isVisible() {
        return this.componentsPanel.isVisible();
    }

    private final void mountBasicGridPanel(JPanel panel, List<SimpleParameterView<?>> views) {
        panel.setLayout(new GridBagLayout());
        if (views == null) {
            return;
        }
        int T = 12;
        int TI = 6;
        int L = 11;
        int B = 12;
        int R = 11;
        int numRows = views.size();
        for (int rowNumber = 0; rowNumber < numRows; ++rowNumber) {
            SimpleParameterView<?> row = views.get(rowNumber);
            if (row == null) continue;
            JComponent[] components = row.getComponents();
            int numCols = components.length;
            for (int colNumber = 0; colNumber < numCols; ++colNumber) {
                JComponent cell = components[colNumber];
                if (cell == null) continue;
                GBC gbc = new GBC(colNumber, rowNumber);
                int gw = 1;
                if (numCols == 1) {
                    gw = 0;
                }
                gbc = gbc.gridheight(1).gridwidth(gw);
                gbc = gbc.west().weights(1.0, 0.0);
                gbc = numRows == 1 ? gbc.insets(12, 11, 12, 11) : (rowNumber == 0 ? gbc.insets(12, 11, 0, 11) : (rowNumber == numRows - 1 ? gbc.insets(6, 11, 12, 11) : gbc.insets(6, 11, 0, 11)));
                if (colNumber == 1 || numCols == 1) {
                    gbc = row.fillVerticalSpace() ? gbc.both() : gbc.horizontal();
                    gbc = gbc.weightx(100.0);
                } else {
                    gbc = gbc.none().west();
                }
                panel.add((Component)cell, gbc);
            }
        }
    }

    public void populatePanel() {
        this.componentsPanel.removeAll();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weightx = 1.0;
        LinkedList views = new LinkedList();
        for (ParameterView<?> parameterView : this.parameterViews) {
            if (parameterView instanceof SimpleParameterView) {
                SimpleParameterView simpleParameterView = (SimpleParameterView)parameterView;
                views.add(simpleParameterView);
                continue;
            }
            if (!(parameterView instanceof ParameterGroupView)) continue;
            if (!views.isEmpty()) {
                JPanel componentPanel = new JPanel();
                this.mountBasicGridPanel(componentPanel, views);
                if (this.resizesVertically(views)) {
                    constraints.fill = 1;
                    constraints.weighty = 1.0;
                } else {
                    constraints.fill = 2;
                    constraints.weighty = 0.0;
                }
                views.clear();
                this.componentsPanel.add((Component)componentPanel, constraints);
                ++constraints.gridy;
            }
            ParameterGroupView parameterGroupView = (ParameterGroupView)parameterView;
            parameterGroupView.populatePanel();
            JPanel groupPanel = parameterGroupView.getPanel();
            if (parameterGroupView.fillVerticalSpace()) {
                constraints.fill = 1;
                constraints.weighty = 1.0;
            } else {
                constraints.fill = 2;
                constraints.weighty = 0.0;
            }
            this.componentsPanel.add((Component)groupPanel, constraints);
            ++constraints.gridy;
        }
        if (!views.isEmpty()) {
            JPanel componentPanel = new JPanel();
            this.mountBasicGridPanel(componentPanel, views);
            if (this.resizesVertically(views)) {
                constraints.fill = 1;
                constraints.weighty = 1.0;
            } else {
                constraints.fill = 2;
                constraints.weighty = 0.0;
            }
            this.componentsPanel.add((Component)componentPanel, constraints);
            ++constraints.gridy;
        }
        if (this.parameterLoaderView != null) {
            JPanel loaderPanel = new JPanel(new FlowLayout(2));
            loaderPanel.add(this.parameterLoaderView.getComponent());
            constraints.fill = 2;
            constraints.weighty = 0.0;
            this.componentsPanel.add((Component)loaderPanel, constraints);
        }
        this.componentsPanel.revalidate();
    }

    private boolean resizesVertically(List<? extends ParameterView<?>> paramViews) {
        for (ParameterView<?> paramView : paramViews) {
            if (!paramView.fillVerticalSpace() || !paramView.isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setVisible(boolean isVisible) {
        this.componentsPanel.setVisible(isVisible);
        this.componentsPanel.revalidate();
    }

    @Override
    public ViewValidationResult validate(ValidationMode mode) throws RemoteException {
        Iterator<ParameterView<?>> parameterViewIterator = this.parameterViews.iterator();
        ViewValidationResult result = new ViewValidationResult(this);
        while (parameterViewIterator.hasNext()) {
            ParameterView<?> view = parameterViewIterator.next();
            ViewValidationResult validation = view.validate(mode);
            result.addChild((Validation)validation);
        }
        if (this.parameterLoaderView != null) {
            result.addChild((Validation)this.parameterLoaderView.validate(mode));
        }
        return result;
    }

    @Override
    public boolean highlightValidationResult(ViewValidationResult result) {
        ViewValidator element = (ViewValidator)result.getElement();
        boolean highlighted = false;
        if (element.equals(this)) {
            for (Validation childResult : result.getChildren()) {
                if (!(childResult instanceof ViewValidationResult)) continue;
                ViewValidationResult viewChildResult = (ViewValidationResult)childResult;
                highlighted |= ((ViewValidator)viewChildResult.getElement()).highlightValidationResult(viewChildResult);
            }
        }
        if (highlighted && !result.isWellSucceeded()) {
            if (this.componentsPanel instanceof ExpandablePanel) {
                ExpandablePanel expandablePanel = (ExpandablePanel)this.componentsPanel;
                expandablePanel.setExpanded(true);
            }
            return true;
        }
        return false;
    }

    public ParameterGroupView(SimpleAlgorithmConfiguratorPanel configurationPanel, ParameterGroup group, ParameterView.Mode mode) {
        super(group, mode);
        this.configurationPanel = configurationPanel;
        this.listeners = new LinkedList<ParameterGroupViewListener>();
        this.createParameterViews();
        this.createParameterLoaderView();
        this.createComponentsPanel();
        this.createParameterListeners();
    }
}

