/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.AbstractSimpleApplicationPanel;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.DataPropertiesListener;
import csbase.client.applications.algorithmsmanager.dialogs.DataBindingPanel;
import csbase.client.applications.algorithmsmanager.models.DataInterface;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;

public class AlgorithmsAndCategoriesBindPanel
extends AbstractSimpleApplicationPanel<AlgorithmsManager>
implements DataPropertiesListener {
    private DataInterface currentData;
    private SortedSet<DataInterface> availableItems;
    private SortedSet<DataInterface> selectedItems;
    private DataBindingPanel dataBindPanel;
    private ItemType itemType;
    private List<DataPropertiesListener> bindListeners;

    public AlgorithmsAndCategoriesBindPanel(AlgorithmsManager application, DataInterface currentData, SortedSet<DataInterface> availableItems, SortedSet<DataInterface> selectedItems, ItemType itemType) {
        super(application);
        this.currentData = currentData;
        this.availableItems = availableItems;
        this.selectedItems = selectedItems;
        this.itemType = itemType;
        this.bindListeners = new Vector<DataPropertiesListener>();
        this.buildPanel();
    }

    private JPanel getDataBindingPanel() {
        this.dataBindPanel = new DataBindingPanel((AlgorithmsManager)this.getApplication(), this.availableItems, this.selectedItems, this.getDataBindingDescription());
        this.dataBindPanel.addDataBindListener(this);
        return this.dataBindPanel;
    }

    private boolean isCategoryItem() {
        return this.itemType.equals((Object)ItemType.CATEGORY_ITEM);
    }

    public List<String> getSelectedCategoriesIds() {
        Vector<String> categoryIds = new Vector<String>();
        if (this.isCategoryItem()) {
            categoryIds = Arrays.asList(this.getSelectedItemIds().toArray(new String[0]));
        } else {
            categoryIds.add(this.getCurrentData().getId());
        }
        return categoryIds;
    }

    public List<Object> getSelectedAlgorithmsIds() {
        Vector<Object> algorithmIds = new Vector<String>();
        if (!this.isCategoryItem()) {
            algorithmIds = this.getSelectedItemIds();
        } else {
            algorithmIds.add(this.getCurrentData().getId());
        }
        return algorithmIds;
    }

    private List<Object> getSelectedItemIds() {
        Vector<Object> selectedIds = new Vector<Object>();
        List<DataInterface> selectedItems = this.dataBindPanel.getSelectedItems();
        for (DataInterface item : selectedItems) {
            selectedIds.add(item.getId());
        }
        return selectedIds;
    }

    public DataInterface getCurrentData() {
        return this.currentData;
    }

    @Override
    protected void buildPanel() {
        this.setLayout(new GridBagLayout());
        JPanel dataBindingPanel = this.getDataBindingPanel();
        this.add((Component)dataBindingPanel, new GBC(0, 1).both().west().insets(5, 5, 5, 5));
    }

    private String getDataBindingDescription() {
        String label = this.isCategoryItem() ? this.getString("AlgorithmsAndCategoriesBindPanel.label.binding.category") : this.getString("AlgorithmsAndCategoriesBindPanel.label.binding.algorithm");
        return label;
    }

    public void updateItems(SortedSet<DataInterface> availableData, SortedSet<DataInterface> selectedData) {
        this.dataBindPanel.updateItems(availableData, selectedData);
    }

    public void setCurrentData(DataInterface currentData) {
        this.currentData = currentData;
    }

    public void bindData() {
        DataInterface currentData = this.getCurrentData();
        if (currentData == null) {
            return;
        }
        this.setCurrentData(currentData);
        List<Object> algorithmIds = this.getSelectedAlgorithmsIds();
        List<String> categoryIds = this.getSelectedCategoriesIds();
        if (this.isCategoryItem()) {
            this.updateCategoriesAlgorithms(algorithmIds, categoryIds);
        } else {
            this.setAlgorithmsToCategories(algorithmIds, categoryIds);
        }
    }

    private void setAlgorithmsToCategories(List<Object> algorithmIds, List<String> categoryIds) {
        CategorySet modifiedCategories = AlgorithmManagementProxy.setAlgorithmsToCategories(algorithmIds, categoryIds, ((AlgorithmsManager)this.getApplication()).getApplicationFrame(), AlgorithmManagementProxy.AlgorithmOperation.ADMIN_ALGORITHM);
        if (modifiedCategories.isEmpty() || modifiedCategories.getSize() != categoryIds.size()) {
            String msg = this.getString("AlgorithmsAndCategoriesBindPanel.msg.create.failed");
            MessageFormat.format(msg, modifiedCategories.getSize());
            ((AlgorithmsManager)this.getApplication()).showError(msg);
        }
    }

    private void updateCategoriesAlgorithms(List<Object> algorithmIds, List<String> categoryIds) {
        CategorySet bindModifiedCategories = this.bindAlgorithmsToCategories(algorithmIds, categoryIds);
        if (bindModifiedCategories == null) {
            return;
        }
        List<String> unbindCategoryIds = this.getRemovedCategoriesIds(this.selectedItems, bindModifiedCategories);
        CategorySet unbindModifiedCategories = this.unbindAlgorithmsToCategories(algorithmIds, unbindCategoryIds);
        if (unbindModifiedCategories == null) {
            return;
        }
        Integer categoriesCounter = categoryIds.size() + unbindCategoryIds.size();
        Integer modifiedCounter = bindModifiedCategories.getSize() + unbindModifiedCategories.getSize();
        if (modifiedCounter == 0 || modifiedCounter != categoriesCounter) {
            String msg = this.getString("AlgorithmsAndCategoriesBindPanel.msg.create.failed");
            MessageFormat.format(msg, modifiedCounter);
            ((AlgorithmsManager)this.getApplication()).showError(msg);
        }
    }

    private List<String> getRemovedCategoriesIds(SortedSet<DataInterface> oldCategories, CategorySet selectedCategories) {
        Vector<String> removedCategories = new Vector<String>();
        if (selectedCategories != null) {
            for (DataInterface oldCategory : oldCategories) {
                String removedCatId = oldCategory.getId();
                Category category = selectedCategories.getRootCategory(removedCatId);
                if (category != null) continue;
                removedCategories.add(removedCatId);
            }
        }
        return removedCategories;
    }

    public CategorySet bindAlgorithmsToCategories(List<Object> algorithmIds, List<String> categoryIds) {
        return AlgorithmManagementProxy.bindAlgorithmsToCategories(algorithmIds, categoryIds, ((AlgorithmsManager)this.getApplication()).getApplicationFrame(), AlgorithmManagementProxy.AlgorithmOperation.ADMIN_ALGORITHM);
    }

    public CategorySet unbindAlgorithmsToCategories(List<Object> algorithmIds, List<String> categoryIds) {
        return AlgorithmManagementProxy.unbindAlgorithmsFromCategories(algorithmIds, categoryIds, ((AlgorithmsManager)this.getApplication()).getApplicationFrame(), AlgorithmManagementProxy.AlgorithmOperation.ADMIN_ALGORITHM);
    }

    public void initializeData(DataInterface selectedAlgorithm, SortedSet<DataInterface> availableCategories, SortedSet<DataInterface> algorithmCategories) {
        this.setCurrentData(selectedAlgorithm);
        this.availableItems = availableCategories;
        this.selectedItems = algorithmCategories;
        this.updateItems(availableCategories, algorithmCategories);
        this.revalidate();
    }

    public boolean wasModified() {
        if (this.isCategoryItem()) {
            return this.wasCategoriesChanged();
        }
        return this.wasAlgorithmsChanged();
    }

    private boolean wasAlgorithmsChanged() {
        List<Object> selectedAlgorithmIds = this.getSelectedAlgorithmsIds();
        if (this.selectedItems.size() != selectedAlgorithmIds.size()) {
            return true;
        }
        for (DataInterface oldCategory : this.selectedItems) {
            String oldCatId = oldCategory.getId();
            if (selectedAlgorithmIds.contains(oldCatId)) continue;
            return true;
        }
        return false;
    }

    private boolean wasCategoriesChanged() {
        if (!this.isCategoryItem()) {
            return false;
        }
        List<String> selectedCategoriesIds = this.getSelectedCategoriesIds();
        if (this.selectedItems.size() != selectedCategoriesIds.size()) {
            return true;
        }
        for (DataInterface oldCategory : this.selectedItems) {
            String oldCatId = oldCategory.getId();
            if (selectedCategoriesIds.contains(oldCatId)) continue;
            return true;
        }
        return false;
    }

    public void addBindListener(DataPropertiesListener bindListener) {
        this.bindListeners.add(bindListener);
    }

    public void removeBindListener(DataPropertiesListener bindListener) {
        this.bindListeners.remove(bindListener);
    }

    public void notifyBindListener() {
        for (DataPropertiesListener bindListener : this.bindListeners) {
            bindListener.propertiesChanged(this.wasModified());
        }
    }

    @Override
    public void propertiesChanged(boolean wasModified) {
        this.notifyBindListener();
    }

    public static enum ItemType {
        CATEGORY_ITEM,
        ALGORITHM_ITEM;

    }
}

