/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.diskmonitor.panels;

import csbase.client.applications.diskmonitor.DiskMonitor;
import csbase.client.applications.diskmonitor.panels.core.DiskMonitorPanel;
import csbase.client.remote.srvproxies.DiskUsageProxy;
import csbase.logic.Utilities;
import csbase.logic.diskusageservice.DiskOccupation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.swing.JComponent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.Rotation;
import tecgraf.javautils.gui.BorderUtil;

public class DiskMonitorPieChartPanel
extends DiskMonitorPanel {
    private final JFreeChart jChart = ChartFactory.createPieChart((String)"", null, (boolean)true, (boolean)false, (boolean)false);
    private LegendTitle internalLegend = this.jChart.getLegend();

    public DiskMonitorPieChartPanel(DiskMonitor application) {
        super(application);
        ChartPanel chartPanel = new ChartPanel(this.jChart);
        chartPanel.setPopupMenu(null);
        BorderUtil.setLowBorder((JComponent)chartPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)chartPanel, "Center");
    }

    public final void updateChart(String id, DiskOccupation occupation) {
        PiePlot pieplot = (PiePlot)this.jChart.getPlot();
        if (occupation == null || !occupation.isValid()) {
            this.resetChart(id);
            return;
        }
        double free = occupation.getFreeSpaceMb();
        double used = occupation.getUsedSpaceMb();
        if (free < 0.0 || used < 0.0) {
            used = 0.0;
            free = 0.0;
        }
        free /= 1024.0;
        used /= 1024.0;
        this.updateTitles(id);
        pieplot.setNoDataMessage(this.getString("DiskMonitorPieChartPanel.failed.error"));
        String freeStr = this.getString("DiskMonitorPieChartPanel.free.legend");
        String usedStr = this.getString("DiskMonitorPieChartPanel.used.legend");
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)freeStr), free);
        dataset.setValue((Comparable)((Object)usedStr), used);
        StandardPieSectionLabelGenerator labelGen = new StandardPieSectionLabelGenerator("{2}\n{1} gb", Locale.ROOT);
        pieplot.setLabelGenerator((PieSectionLabelGenerator)labelGen);
        StandardPieSectionLabelGenerator legendGen = new StandardPieSectionLabelGenerator("{0}");
        pieplot.setLegendLabelGenerator((PieSectionLabelGenerator)legendGen);
        pieplot.setSectionPaint((Comparable)((Object)freeStr), (Paint)new Color(150, 255, 150));
        pieplot.setSectionPaint((Comparable)((Object)usedStr), (Paint)new Color(255, 150, 150));
        pieplot.setDirection(Rotation.CLOCKWISE);
        pieplot.setBackgroundPaint(null);
        pieplot.setOutlinePaint(null);
        pieplot.setCircular(true);
        pieplot.setDataset((PieDataset)dataset);
    }

    private void updateTitles(String id) {
        String title = DiskUsageProxy.translateAreaId(id);
        if (title == null) {
            title = "---";
        }
        this.jChart.setTitle(title);
        ArrayList<TextTitle> subtitles = new ArrayList<TextTitle>();
        Date now = new Date();
        long time = now.getTime();
        String timeText = Utilities.getFormattedDate((long)time);
        subtitles.add(new TextTitle(timeText));
        this.jChart.setSubtitles(subtitles);
        this.jChart.addLegend(this.internalLegend);
    }

    public final void resetChart(String id) {
        PiePlot pieplot = (PiePlot)this.jChart.getPlot();
        pieplot.setDataset(null);
        this.updateTitles(id);
    }
}

