/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.sgamonitor;

import csbase.client.Client;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.sgamonitor.SGAMonitorPref;
import csbase.client.applications.sgamonitor.actions.DetailsSGAClusterAction;
import csbase.client.applications.sgamonitor.actions.RestartSGAClusterAction;
import csbase.client.applications.sgamonitor.actions.StopSGAClusterAction;
import csbase.client.facilities.configurabletable.UI.TabbedPane4Tables;
import csbase.client.facilities.configurabletable.UI.UI4Tables;
import csbase.client.facilities.configurabletable.UIFactory;
import csbase.client.facilities.configurabletable.model.Config;
import csbase.client.facilities.configurabletable.stringprovider.ApplicationStringProvider;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import csbase.client.facilities.configurabletable.table.RowToKey;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.types.PVTables;
import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.logic.AttributesPermission;
import csbase.logic.SGAAdminPermission;
import csbase.logic.SGANotification;
import csbase.logic.SGASet;
import csbase.logic.User;
import csbase.logic.Utilities;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.gui.StatusBar;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class SGAMonitor
extends Application {
    private static final String MAIN_PANEL = "main-panel";
    private Action detailsSGAClusterAction;
    private Action restartSGAClusterAction;
    private Action stopSGAClusterAction;
    private UI4Tables ui4Tables;
    private Config config = this.getTablesConfig();
    private IMessageListener sgaListener;
    private boolean SGAAdministrationPermission;

    public SGAMonitor(String id) throws ApplicationException, RemoteException {
        super(id);
        ApplicationStringProvider stringProvider = new ApplicationStringProvider(this);
        UIFactory uiFactory = new UIFactory(this.config, stringProvider);
        this.ui4Tables = uiFactory.getUI4Tables(MAIN_PANEL);
        this.buildActions();
        this.buildInterface();
        this.addTableSelectionObject();
        this.addTableListeners();
        this.loadTablePreferences();
        this.SGAAdministrationPermission = this.checkSGAAdministrationPermission();
        this.sgaListener = new IMessageListener(){

            public void onMessagesReceived(Message ... messages) throws Exception {
                final ArrayList<SGASet> newRows = new ArrayList<SGASet>();
                for (Message aMessage : messages) {
                    SGANotification notification = (SGANotification)aMessage.getBody();
                    newRows.add(notification.getMainInfo());
                }
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        List<ConfigurableTable<SGASet>> tables = SGAMonitor.this.ui4Tables.getAllTables(SGASet.class);
                        if (tables.size() == 0) {
                            return;
                        }
                        HashMap<String, SGASet> rows = new HashMap<String, SGASet>();
                        ArrayList<SGASet> oldRows = new ArrayList<SGASet>();
                        for (ConfigurableTable<SGASet> table : tables) {
                            oldRows.addAll(table.getRows());
                        }
                        for (SGASet anOldRow : oldRows) {
                            rows.put(anOldRow.getName(), anOldRow);
                        }
                        for (SGASet aNewRow : newRows) {
                            rows.put(aNewRow.getName(), aNewRow);
                        }
                        SGAMonitor.this.setData(new ArrayList(rows.values()));
                    }
                });
            }
        };
        MessageProxy.addListener(this.sgaListener, SGANotification.class);
        final List<SGASet> data = this.getSGASetList();
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SGAMonitor.this.setData(data);
            }
        });
    }

    public List<SGASet> getSelectedSGAs() {
        ArrayList<SGASet> selectedSGAs = new ArrayList<SGASet>();
        for (ConfigurableTable<SGASet> table : this.ui4Tables.getTablesFromSelectedComponent(SGASet.class)) {
            selectedSGAs.addAll(table.getSelectedObjects());
        }
        return selectedSGAs;
    }

    public Config getConfig() {
        return this.config;
    }

    public void refreshTables() {
        for (ConfigurableTable<?> table : this.ui4Tables.getAllTables()) {
            table.updateRows();
        }
    }

    @Override
    public void killApplication() {
        PreferenceCategory appPrefs = this.getPreferences();
        PVTables pv = (PVTables)appPrefs.getPreference(SGAMonitorPref.MAIN_TABLES);
        pv.storeTables(this.ui4Tables.getAllTables());
        this.savePreferences();
        MessageProxy.removeListener(this.sgaListener);
    }

    @Override
    protected boolean userCanKillApplication() {
        return true;
    }

    protected void updateActions() {
        List<SGASet> selectedObjects = this.getSelectedSGAs();
        this.detailsSGAClusterAction.setEnabled(false);
        this.restartSGAClusterAction.setEnabled(false);
        this.stopSGAClusterAction.setEnabled(false);
        boolean allAlive = true;
        for (SGASet sga : selectedObjects) {
            if (sga.getAlive()) continue;
            allAlive = false;
            break;
        }
        if (this.SGAAdministrationPermission && selectedObjects.size() > 0 && allAlive) {
            this.restartSGAClusterAction.setEnabled(true);
            this.stopSGAClusterAction.setEnabled(true);
        }
        if (selectedObjects.size() == 1 && allAlive) {
            this.detailsSGAClusterAction.setEnabled(true);
        }
    }

    /*
     * Exception decompiling
     */
    private Config getTablesConfig() throws ApplicationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JMenuBar createMenuBar() {
        JMenu serversMenu = new JMenu(this.getString("menu.servers"));
        serversMenu.add(this.detailsSGAClusterAction);
        serversMenu.add(this.restartSGAClusterAction);
        serversMenu.add(this.stopSGAClusterAction);
        serversMenu.addSeparator();
        serversMenu.add(new ApplicationExitAction(this));
        JMenu tablesMenu = new JMenu(this.getString("menu.tables"));
        for (ConfigurableTable<?> table : this.ui4Tables.getAllTables()) {
            JMenu subMenu = new JMenu(this.ui4Tables.getTableLabel(table.getId()));
            for (JCheckBoxMenuItem item : table.createColumnsCheckBoxes()) {
                subMenu.add(item);
            }
            tablesMenu.add(subMenu);
        }
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(serversMenu);
        menuBar.add(tablesMenu);
        return menuBar;
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.detailsSGAClusterAction);
        toolBar.add(this.restartSGAClusterAction);
        toolBar.add(this.stopSGAClusterAction);
        return toolBar;
    }

    private void addTableListeners() {
        for (final ConfigurableTable<?> table : this.ui4Tables.getAllTables()) {
            table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SGAMonitor.this.updateActions();
                }
            });
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!e.isControlDown()) {
                        for (ConfigurableTable<?> otherTable : SGAMonitor.this.ui4Tables.getAllTables()) {
                            if (otherTable.getId().equals(table.getId())) continue;
                            otherTable.clearSelection();
                        }
                    }
                    if (e.getClickCount() == 2) {
                        SGAMonitor.this.detailsSGAClusterAction.actionPerformed(null);
                    }
                }
            });
        }
        if (this.ui4Tables instanceof TabbedPane4Tables) {
            ((TabbedPane4Tables)this.ui4Tables).addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SGAMonitor.this.updateActions();
                }
            });
        }
    }

    private void addTableSelectionObject() {
        for (ConfigurableTable<SGASet> table : this.ui4Tables.getAllTables(SGASet.class)) {
            table.setRowToKey(new RowToKey<SGASet>(){

                @Override
                public String getKey(SGASet row) {
                    return row.getName();
                }
            });
        }
    }

    private void buildActions() {
        this.detailsSGAClusterAction = new DetailsSGAClusterAction(this);
        this.detailsSGAClusterAction.setEnabled(false);
        this.restartSGAClusterAction = new RestartSGAClusterAction(this);
        this.restartSGAClusterAction.setEnabled(false);
        this.stopSGAClusterAction = new StopSGAClusterAction(this);
        this.stopSGAClusterAction.setEnabled(false);
    }

    private void buildInterface() {
        ApplicationFrame appFrame = this.getApplicationFrame();
        appFrame.setLayout(new BorderLayout());
        appFrame.setJMenuBar(this.createMenuBar());
        Container appContentPane = appFrame.getContentPane();
        appContentPane.add((Component)this.createToolBar(), "North");
        appContentPane.add((Component)((Object)this.ui4Tables), "Center");
        appFrame.pack();
    }

    private void loadTablePreferences() {
        PreferenceCategory appPrefs = this.getPreferences();
        PVTables pv = (PVTables)appPrefs.getPreference(SGAMonitorPref.MAIN_TABLES);
        pv.loadTables(this.ui4Tables.getAllTables());
    }

    private void setData(List<SGASet> data) {
        List<ConfigurableTable<SGASet>> tables = this.ui4Tables.getAllTables(SGASet.class);
        for (ConfigurableTable<SGASet> table : tables) {
            table.updateRows(data);
        }
        StatusBar st = this.getApplicationFrame().getStatusBar();
        String timeText = Utilities.getFormattedDate((long)new Date().getTime());
        st.setInfo(this.getString("console.last.update") + timeText);
        this.setChanged();
        this.notifyObservers(data);
    }

    private List<SGASet> getSGASetList() throws RemoteException {
        SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        Vector sgaNames = sgaService.getAllSGANames();
        ArrayList<SGASet> newRows = new ArrayList<SGASet>();
        for (int i = 0; i < sgaNames.size(); ++i) {
            String name = (String)sgaNames.get(i);
            SGASet sga = sgaService.getSGASet(name);
            newRows.add(sga);
        }
        return newRows;
    }

    private boolean checkSGAAdministrationPermission() {
        User user = User.getLoggedUser();
        if (user.isAdmin()) {
            return true;
        }
        String serverName = "local=" + Client.getInstance().getSystemName();
        AttributesPermission p = null;
        try {
            p = user.getMatchAttributesPermission(SGAAdminPermission.class, serverName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return p != null;
    }
}

